package com.biz.crm.common.pay.business.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.mapper.PaymentAccountMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 电子账户信息表(MdmPaymentAccount)表数据库访问层
 *
 * @author HanJiaJun
 * @since 2022-08-18 11:15:13
 */
@Component
public class PaymentAccountRepository extends ServiceImpl<PaymentAccountMapper, PaymentAccount> {

  @Autowired
  private PaymentAccountMapper paymentAccountMapper;

  /**
   * 分页查询数据
   *
   * @param pageable          分页对象
   * @param mdmPaymentAccount 实体对象
   * @return
   */
  public Page<PaymentAccount> findByConditions(Pageable pageable, PaymentAccount mdmPaymentAccount) {
    Page<PaymentAccount> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<PaymentAccount> pageList = paymentAccountMapper.findByConditions(page, mdmPaymentAccount);
    return pageList;
  }

  /**
   * 查询开户信息，开户信息只能存在一条记录
   * @return
   */
  public List<PaymentAccount> findLocalUserInfo() {
  return this.lambdaQuery()
      .eq(PaymentAccount::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
      .list();

  }

}

