package com.biz.crm.common.pay.business.local.service.internal;

import com.biz.crm.common.pay.business.local.entity.PaymentRecord;
import com.biz.crm.common.pay.business.local.service.PaymentRecordService;
import com.biz.crm.common.pay.business.sdk.dto.PaymentRecordDto;
import com.biz.crm.common.pay.business.sdk.service.PaymentRecordVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentRecordVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;

/**
 * @author HanJiaJun
 * @describe:支付流水VO服务接口实现类
 * @createTime 2022年08月12日 14:35:00
 */
@Service
public class PaymentRecordVoServiceImpl implements PaymentRecordVoService {

  @Autowired
  private PaymentRecordService paymentRecordService;
  @Autowired(required = false)
  private NebulaToolkitService nebulaToolkitService;

  /**
   * 创建
   *
   * @param dto
   */
  @Override
  public void create(PaymentRecordDto dto) {
    Validate.notNull(dto,"新增时数据不能为空");
    PaymentRecord paymentRecord = nebulaToolkitService.copyObjectByWhiteList(dto, PaymentRecord.class, HashSet.class, ArrayList.class);
    paymentRecordService.create(paymentRecord);
  }

  /**
   * 更新
   *
   * @param dto
   */
  @Override
  public void update(PaymentRecordDto dto) {
    Validate.notNull(dto,"更新时数据不能为空");
    PaymentRecord paymentRecord = nebulaToolkitService.copyObjectByWhiteList(dto, PaymentRecord.class, HashSet.class, ArrayList.class);
    paymentRecordService.update(paymentRecord);
  }

  @Override
  public void updateStatusByTxSn(String txSn, String status) {
    paymentRecordService.updateStatusByTxSn(txSn,status);
  }

  @Override
  public PaymentRecordVo findByTxSn(String txSN) {
    PaymentRecord byTxSn = paymentRecordService.findByTxSn(txSN);
    if (Objects.isNull(byTxSn)){
      return null;
    }
    return this.nebulaToolkitService.copyObjectByWhiteList(byTxSn,PaymentRecordVo.class,HashSet.class,ArrayList.class);
  }

  @Override
  public PaymentRecordVo findByOrderNo(String OrderNo) {
    PaymentRecord orderNo = paymentRecordService.findByOrderNo(OrderNo);
    if (Objects.isNull(orderNo)){
      return null;
    }
    return this.nebulaToolkitService.copyObjectByWhiteList(orderNo,PaymentRecordVo.class,HashSet.class,ArrayList.class);
  }

  /**
   * 通过交易流水号删除
   * @param txSN
   */
  @Override
  public void deleteQRMsgByTxSn(String txSN) {
    paymentRecordService.deleteQRMsgByTxSn(txSN);
  }
}
