package com.biz.crm.common.pay.business.local.service;


import com.biz.crm.common.pay.business.local.entity.PaymentAccountBank;

import java.util.List;

/**
 * 电子账户绑定银行卡信息(MdmPaymentAccountBank)表服务接口
 *
 * @author HanJiaJun
 * @since 2022-08-18 11:47:54
 */
public interface PaymentAccountBankService {

   /**
   * 新增数据
   * @param mdmPaymentAccountBank 实体对象
   * @return 新增结果
   */
  PaymentAccountBank create(PaymentAccountBank mdmPaymentAccountBank);

  /**
   * 批量创建
   * @param mdmPaymentAccountBank
   */
  void createBrach(List<PaymentAccountBank> mdmPaymentAccountBank);
   /**
   * 修改新据
   * @param mdmPaymentAccountBank 实体对象
   * @return 修改结果
   */
   PaymentAccountBank update(PaymentAccountBank mdmPaymentAccountBank);
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  void delete(List<String> idList);

  /**
   * 根据账户ID查询绑定卡集合
   * @param accountId
   * @return
   */
  List<PaymentAccountBank> findByAccountId(String accountId);

  /**
   * 根据账户ID进行删除
   * @param accountId
   */
  void deleteByAccountId(String accountId);
}

