/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.business.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.pay.business.sdk.dto.PaymentAccountDto;
import com.biz.crm.common.pay.business.sdk.service.PaymentAccountVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountExpandVo;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/pay/paymentAccount"})
@Api(tags={"\u652f\u4ed8\u6a21\u5757 \uff1aPaymentAccountVo \uff1a\u652f\u4ed8\u8d26\u53f7"})
public class PaymentAccountVoController {
    private static final Logger log = LoggerFactory.getLogger(PaymentAccountVoController.class);
    @Autowired(required=false)
    private PaymentAccountVoService paymentAccountVoService;

    @ApiOperation(value="\u901a\u8fc7\u767b\u5f55\u79df\u6237\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"isAvailable"})
    public Result<Boolean> isAvailable() {
        try {
            Boolean result = this.paymentAccountVoService.isAvailable();
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4ece\u4e2d\u91d1\u67e5\u8be2\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"findUserInfo"})
    public Result<PaymentAccountExpandVo> findUserInfo() {
        try {
            PaymentAccountExpandVo result = this.paymentAccountVoService.findUserInfo();
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u672c\u5730\u50a8\u5b58\u7684\u7528\u6237\u4fe1\u606f")
    @GetMapping(value={"findLocalUserInfo"})
    public Result<PaymentAccountVo> findLocalUserInfo() {
        try {
            PaymentAccountVo result = this.paymentAccountVoService.findLocalUserInfo();
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u5f55\u5165\u5f00\u6237\u6570\u636e")
    @PostMapping
    public Result<?> create(@ApiParam(name="PaymentRecord", value="\u624b\u52a8\u5f55\u5165\u5f00\u6237\u6570\u636e") @RequestBody PaymentAccountDto dto) {
        try {
            this.paymentAccountVoService.create(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u624b\u52a8\u7f16\u8f91\u5f00\u6237\u6570\u636e")
    @PatchMapping
    public Result<?> update(@ApiParam(name="PaymentRecord", value="\u624b\u52a8\u7f16\u8f91\u5f00\u6237\u6570\u636e") @RequestBody PaymentAccountDto dto) {
        try {
            this.paymentAccountVoService.update(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

