/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.business.local.service.internal;

import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.entity.PaymentAccountBank;
import com.biz.crm.common.pay.business.local.service.PaymentAccountBankService;
import com.biz.crm.common.pay.business.local.service.PaymentAccountService;
import com.biz.crm.common.pay.business.sdk.dto.PaymentAccountBankDto;
import com.biz.crm.common.pay.business.sdk.dto.PaymentAccountDto;
import com.biz.crm.common.pay.business.sdk.service.PaymentAccountVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountBankVo;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountExpandVo;
import com.biz.crm.common.pay.business.sdk.vo.PaymentAccountVo;
import com.biz.crm.common.pay.support.sdk.service.AccountAuthSupportVoService;
import com.biz.crm.common.pay.support.sdk.service.PaymentAccountSupportVoService;
import com.biz.crm.common.pay.support.sdk.vo.PaymentAccountSupportVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class PaymentAccountVoServiceImpl
implements PaymentAccountVoService {
    @Autowired(required=false)
    private PaymentAccountSupportVoService paymentAccountSupportVoService;
    @Autowired(required=false)
    private AccountAuthSupportVoService accountAuthSupportVoService;
    @Autowired
    private PaymentAccountService paymentAccountService;
    @Autowired
    private PaymentAccountBankService paymentAccountBankService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public Boolean isAvailable() {
        PaymentAccount localUserInfo = this.paymentAccountService.findLocalUserInfo();
        Validate.notNull((Object)((Object)localUserInfo), (String)"\u672c\u5730\u5c1a\u65e0\u5f00\u6237\u4fe1\u606f", (Object[])new Object[0]);
        return this.accountAuthSupportVoService.haveAuthorityToCollectMoney(localUserInfo.getUserId(), null);
    }

    public PaymentAccountExpandVo findUserInfo() {
        PaymentAccount localUserInfo = this.paymentAccountService.findLocalUserInfo();
        Validate.notNull((Object)((Object)localUserInfo), (String)"\u672c\u5730\u5c1a\u65e0\u5f00\u6237\u4fe1\u606f", (Object[])new Object[0]);
        PaymentAccountSupportVo byUserId = this.paymentAccountSupportVoService.findByUserId(localUserInfo.getUserId());
        return (PaymentAccountExpandVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)byUserId, PaymentAccountExpandVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public PaymentAccountVo findLocalUserInfo() {
        PaymentAccount byFirmName = this.paymentAccountService.findLocalUserInfo();
        if (ObjectUtils.isEmpty((Object)((Object)byFirmName))) {
            return null;
        }
        List<PaymentAccountBank> byAccountId = this.paymentAccountBankService.findByAccountId(byFirmName.getId());
        PaymentAccountVo paymentAccountVo = (PaymentAccountVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)byFirmName, PaymentAccountVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isEmpty(byAccountId)) {
            return paymentAccountVo;
        }
        List paymentAccountBankVos = (List)this.nebulaToolkitService.copyCollectionByWhiteList(byAccountId, PaymentAccountBank.class, PaymentAccountBankVo.class, HashSet.class, ArrayList.class, new String[0]);
        paymentAccountVo.setBankList(paymentAccountBankVos);
        return paymentAccountVo;
    }

    @Transactional
    public void create(PaymentAccountDto dto) {
        Validate.notNull((Object)dto, (String)"\u624b\u52a8\u5f55\u5165\u5f00\u6237\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PaymentAccount byFirmName = this.paymentAccountService.findLocalUserInfo();
        Validate.isTrue((boolean)ObjectUtils.isEmpty((Object)((Object)byFirmName)), (String)"\u5df2\u5b58\u5728\u5f00\u6237\u4fe1\u606f", (Object[])new Object[0]);
        PaymentAccount paymentAccount = (PaymentAccount)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, PaymentAccount.class, HashSet.class, ArrayList.class, new String[0]));
        this.paymentAccountService.create(paymentAccount);
        List bankList = dto.getBankList();
        String id = paymentAccount.getId();
        if (!CollectionUtils.isEmpty((Collection)bankList)) {
            List paymentAccountBanks = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)bankList, PaymentAccountBankDto.class, PaymentAccountBank.class, HashSet.class, ArrayList.class, new String[0]);
            paymentAccountBanks.forEach(e -> e.setAccountId(id));
            this.paymentAccountBankService.createBrach(paymentAccountBanks);
        }
    }

    public void update(PaymentAccountDto dto) {
        Validate.notNull((Object)dto, (String)"\u624b\u52a8\u7f16\u8f91\u5f00\u6237\u4fe1\u606f\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PaymentAccount paymentAccount = (PaymentAccount)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, PaymentAccount.class, HashSet.class, ArrayList.class, new String[0]));
        this.paymentAccountService.update(paymentAccount);
        List bankList = dto.getBankList();
        String id = paymentAccount.getId();
        this.paymentAccountBankService.deleteByAccountId(id);
        if (!CollectionUtils.isEmpty((Collection)bankList)) {
            List paymentAccountBanks = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)bankList, PaymentAccountBankDto.class, PaymentAccountBank.class, HashSet.class, ArrayList.class, new String[0]);
            paymentAccountBanks.forEach(e -> e.setAccountId(id));
            this.paymentAccountBankService.createBrach(paymentAccountBanks);
        }
    }
}

