/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.business.local.service.internal;

import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.common.pay.business.local.entity.PaymentAccount;
import com.biz.crm.common.pay.business.local.service.PaymentAccountService;
import com.biz.crm.common.pay.business.sdk.dto.PayBusinessDto;
import com.biz.crm.common.pay.business.sdk.dto.PaymentRecordDto;
import com.biz.crm.common.pay.business.sdk.dto.WithdrawalDto;
import com.biz.crm.common.pay.business.sdk.enums.PayOperationType;
import com.biz.crm.common.pay.business.sdk.enums.PayRecordOperationTypeEnum;
import com.biz.crm.common.pay.business.sdk.enums.PayWayEnum;
import com.biz.crm.common.pay.business.sdk.service.PaymentOperationVoService;
import com.biz.crm.common.pay.business.sdk.service.PaymentRecordVoService;
import com.biz.crm.common.pay.business.sdk.vo.PaymentOperationVo;
import com.biz.crm.common.pay.business.sdk.vo.PaymentRecordVo;
import com.biz.crm.common.pay.support.sdk.dto.ExtractCashDto;
import com.biz.crm.common.pay.support.sdk.dto.transfer.AppletPayDto;
import com.biz.crm.common.pay.support.sdk.dto.transfer.PayDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.service.CustomerPaySupportVoService;
import com.biz.crm.common.pay.support.sdk.service.CustomerRechargeSupportVoService;
import com.biz.crm.common.pay.support.sdk.service.ExtractCashService;
import com.biz.crm.common.pay.support.sdk.service.TxSnGenerateService;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.Redirect7Wechat7Applet;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.Scan7Aggregate7Forward;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.TransferCarrier;
import com.biz.crm.common.sms.sdk.service.ValiditySmsCodeService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class PaymentOperationVoServiceImpl
implements PaymentOperationVoService {
    private static final Logger log = LoggerFactory.getLogger(PaymentOperationVoServiceImpl.class);
    @Autowired(required=false)
    private ExtractCashService extractCashService;
    @Autowired(required=false)
    private ValiditySmsCodeService validitySmsCodeService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private CustomerRechargeSupportVoService customerRechargeSupportVoService;
    @Autowired
    private PaymentAccountService paymentAccountService;
    @Autowired(required=false)
    private PaymentRecordVoService paymentRecordVoService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired(required=false)
    private CustomerPaySupportVoService customerPaySupportVoService;
    @Autowired(required=false)
    private TxSnGenerateService txSnGenerateService;
    @Value(value="${weixing.dms.appID:}")
    private String appID;
    @Value(value="${weixing.dms.openID:}")
    private String openID;
    private static final String RECHARGE_RULE_CODE = "CZ";

    public String withdrawal(WithdrawalDto dto) {
        Validate.notNull((Object)dto, (String)"\u63d0\u73b0\u65f6\uff0c\u5bf9\u8c61\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        String verificationCode = dto.getVerificationCode();
        Validate.notBlank((CharSequence)verificationCode, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        verificationCode = verificationCode.concat(PayOperationType.WITHDRAWAL.getDictCode());
        Assert.isTrue((boolean)false, (String)"\u3010\u4f53\u73b0\u3011\u5f53\u524d\u4e0d\u652f\u6301\u6b64\u77ed\u4fe1\u7c7b\u578b!");
        Boolean availableVerificationCode = false;
        Validate.isTrue((boolean)availableVerificationCode, (String)"\u9a8c\u8bc1\u7801\u9519\u8bef\u6216\u8005\u5931\u6548!", (Object[])new Object[0]);
        ExtractCashDto extractCashDto = new ExtractCashDto();
        extractCashDto.setAmount(dto.getAmount());
        extractCashDto.setBankAccountNumber(dto.getBindingTxSN());
        extractCashDto.setArrivalType(dto.getArrivalType());
        PaymentAccount localUserInfo = this.paymentAccountService.findLocalUserInfo();
        extractCashDto.setUserID(localUserInfo.getUserId());
        ResponseModel model = this.extractCashService.sendRequest(extractCashDto);
        Validate.notNull((Object)model, (String)"\u63d0\u73b0\u5931\u8d25!", (Object[])new Object[0]);
        Validate.isTrue((boolean)model.getSuccess(), (String)model.getMessage(), (Object[])new Object[0]);
        return model.getMessage();
    }

    @Transactional
    public PaymentOperationVo recharge(PayBusinessDto dto) {
        ResponseModel recharge;
        Validate.notNull((Object)dto, (String)"\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPayWay(), (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        PaymentAccount localUserInfo = this.paymentAccountService.findLocalUserInfo();
        String txSn = this.txSnGenerateService.create();
        Object vo = null;
        if (dto.getPayWay().equals(PayWayEnum.QR.getDictCode())) {
            PayDto payDto = new PayDto();
            payDto.setAmount(dto.getAmount());
            payDto.setPayerUserID(dto.getPayerUserID());
            payDto.setRemark(dto.getRemark());
            payDto.setExpirePeriod("15m");
            payDto.setTxSN(txSn);
            payDto.setGoodsName(dto.getGoodsName());
            payDto.setOrderNo(dto.getOrderNo());
            payDto.setPayeeUserID(localUserInfo.getUserId());
            Scan7Aggregate7Forward scan7Aggregate7Forward = new Scan7Aggregate7Forward(payDto);
            recharge = this.customerRechargeSupportVoService.recharge((TransferCarrier)scan7Aggregate7Forward);
            vo = scan7Aggregate7Forward.getVo(recharge.getResponse());
            Validate.notNull((Object)vo, (String)("\u4e2d\u91d1\u9519\u8bef\u4fe1\u606f:" + recharge.getMessage()), (Object[])new Object[0]);
        } else {
            AppletPayDto appletPayDto = new AppletPayDto();
            appletPayDto.setGoodsName(dto.getGoodsName());
            appletPayDto.setAmount(dto.getAmount());
            appletPayDto.setSubAppID(dto.getSubAppID());
            appletPayDto.setSubOpenID(dto.getSubOpenID());
            appletPayDto.setPayerUserID(dto.getPayerUserID());
            appletPayDto.setRemark(dto.getRemark());
            appletPayDto.setExpirePeriod("15m");
            appletPayDto.setTxSN(txSn);
            appletPayDto.setOrderNo(dto.getOrderNo());
            appletPayDto.setPayeeUserID(localUserInfo.getUserId());
            appletPayDto.setSubAppID(this.appID);
            appletPayDto.setSubOpenID(this.openID);
            Redirect7Wechat7Applet redirect7Wechat7Applet = new Redirect7Wechat7Applet(appletPayDto);
            recharge = this.customerRechargeSupportVoService.recharge((TransferCarrier)redirect7Wechat7Applet);
            vo = redirect7Wechat7Applet.getVo(recharge.getResponse());
            Validate.notNull((Object)vo, (String)("\u4e2d\u91d1\u9519\u8bef\u4fe1\u606f:" + recharge.getMessage()), (Object[])new Object[0]);
        }
        PaymentRecordDto paymentRecordDto = new PaymentRecordDto();
        BigDecimal amount = new BigDecimal(dto.getAmount());
        BigDecimal hundred = new BigDecimal("100");
        BigDecimal actualAmount = amount.divide(hundred);
        paymentRecordDto.setAmount(actualAmount);
        paymentRecordDto.setOperationType(PayRecordOperationTypeEnum.RECHARGE.getDictCode());
        paymentRecordDto.setOperationTime(new Date());
        paymentRecordDto.setTxSn(txSn);
        paymentRecordDto.setCustomerCode(dto.getCustomerCode());
        List strings = this.generateCodeService.generateCode(RECHARGE_RULE_CODE, 1);
        paymentRecordDto.setRelationshipDocNumber((String)strings.get(0));
        this.paymentRecordVoService.create(paymentRecordDto);
        return (PaymentOperationVo)this.nebulaToolkitService.copyObjectByWhiteList(vo, PaymentOperationVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public PaymentOperationVo pay(PayBusinessDto dto) {
        ResponseModel pay;
        Validate.notNull((Object)dto, (String)"\u6570\u636e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getPayWay(), (String)"\u652f\u4ed8\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getOrderNo(), (String)"\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        PaymentRecordVo byOrderNo = this.paymentRecordVoService.findByOrderNo(dto.getOrderNo());
        if (dto.getPayWay().equals(PayWayEnum.QR.getDictCode())) {
            if (Objects.nonNull(byOrderNo) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{byOrderNo.getQrCodeUrl(), byOrderNo.getQrImageUrl()})) {
                PaymentOperationVo operationVo = new PaymentOperationVo();
                operationVo.setQRCodeURL(byOrderNo.getQrCodeUrl());
                operationVo.setQRImageURL(byOrderNo.getQrImageUrl());
                operationVo.setQRAuthCode(byOrderNo.getQrAuthCode());
                return operationVo;
            }
        } else if (Objects.nonNull(byOrderNo) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{byOrderNo.getQrAuthCode()})) {
            PaymentOperationVo operationVo = new PaymentOperationVo();
            operationVo.setQRCodeURL(byOrderNo.getQrCodeUrl());
            operationVo.setQRImageURL(byOrderNo.getQrImageUrl());
            operationVo.setQRAuthCode(byOrderNo.getQrAuthCode());
            return operationVo;
        }
        PaymentAccount localUserInfo = this.paymentAccountService.findLocalUserInfo();
        String txSn = this.txSnGenerateService.create();
        Object vo = null;
        if (dto.getPayWay().equals(PayWayEnum.QR.getDictCode())) {
            PayDto payDto = new PayDto();
            payDto.setAmount(dto.getAmount());
            payDto.setPayerUserID(dto.getPayerUserID());
            payDto.setRemark(dto.getRemark());
            payDto.setExpirePeriod("15m");
            payDto.setOrderNo(dto.getOrderNo());
            payDto.setGoodsName(dto.getGoodsName());
            payDto.setTxSN(txSn);
            payDto.setPayeeUserID(localUserInfo.getUserId());
            Scan7Aggregate7Forward scan7Aggregate7Forward = new Scan7Aggregate7Forward(payDto);
            pay = this.customerPaySupportVoService.pay((TransferCarrier)scan7Aggregate7Forward);
            vo = scan7Aggregate7Forward.getVo(pay.getResponse());
            Validate.notNull((Object)vo, (String)("\u4e2d\u91d1\u9519\u8bef\u4fe1\u606f:" + pay.getMessage()), (Object[])new Object[0]);
        } else {
            AppletPayDto appletPayDto = new AppletPayDto();
            appletPayDto.setGoodsName(dto.getGoodsName());
            appletPayDto.setAmount(dto.getAmount());
            appletPayDto.setSubAppID(dto.getSubAppID());
            appletPayDto.setSubOpenID(dto.getSubOpenID());
            appletPayDto.setPayerUserID(dto.getPayerUserID());
            appletPayDto.setRemark(dto.getRemark());
            appletPayDto.setExpirePeriod("15m");
            appletPayDto.setTxSN(txSn);
            appletPayDto.setOrderNo(dto.getOrderNo());
            appletPayDto.setPayeeUserID(localUserInfo.getUserId());
            appletPayDto.setSubAppID(this.appID);
            appletPayDto.setSubOpenID(this.openID);
            Redirect7Wechat7Applet redirect7Wechat7Applet = new Redirect7Wechat7Applet(appletPayDto);
            pay = this.customerPaySupportVoService.pay((TransferCarrier)redirect7Wechat7Applet);
            vo = redirect7Wechat7Applet.getVo(pay.getResponse());
            Validate.notNull((Object)vo, (String)("\u4e2d\u91d1\u9519\u8bef\u4fe1\u606f:" + pay.getMessage()), (Object[])new Object[0]);
        }
        PaymentOperationVo operationVo = (PaymentOperationVo)this.nebulaToolkitService.copyObjectByWhiteList(vo, PaymentOperationVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (Objects.isNull(byOrderNo)) {
            PaymentRecordDto paymentRecordDto = new PaymentRecordDto();
            BigDecimal amount = new BigDecimal(dto.getAmount());
            BigDecimal hundred = new BigDecimal("100");
            BigDecimal actualAmount = amount.divide(hundred);
            paymentRecordDto.setAmount(actualAmount);
            paymentRecordDto.setOperationType(PayRecordOperationTypeEnum.ORDER.getDictCode());
            paymentRecordDto.setOperationTime(new Date());
            paymentRecordDto.setTxSn(txSn);
            paymentRecordDto.setRelationshipDocNumber(dto.getOrderNo());
            paymentRecordDto.setCustomerCode(dto.getCustomerCode());
            paymentRecordDto.setRelationshipDocNumber(dto.getOrderNo());
            paymentRecordDto.setQrAuthCode(operationVo.getQRAuthCode());
            paymentRecordDto.setQrCodeUrl(operationVo.getQRCodeURL());
            paymentRecordDto.setQrImageUrl(operationVo.getQRImageURL());
            this.paymentRecordVoService.create(paymentRecordDto);
        } else {
            byOrderNo.setQrAuthCode(operationVo.getQRAuthCode());
            byOrderNo.setQrCodeUrl(operationVo.getQRCodeURL());
            byOrderNo.setQrImageUrl(operationVo.getQRImageURL());
            byOrderNo.setOperationTime(new Date());
            this.paymentRecordVoService.update((PaymentRecordDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)byOrderNo, PaymentRecordDto.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return operationVo;
    }
}

