package com.biz.crm.common.pay.business.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.common.pay.business.local.service.PaymentSmsVerification;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author HanJiaJun
 * @describe: 支付模块验证码
 * @createTime 2022年08月29日 09:38:00
 */
@RestController
@RequestMapping("/v1/pay/smsVerificationCode")
@Slf4j
@Api(tags = "支付模块 ：Verification ：手机号验证码")
public class PaymentSmsVerificationController {

  @Autowired
  PaymentSmsVerification paymentSmsVerification;


  @ApiOperation(value = "发送手机号验证码")
  @PostMapping("/sendPaymentVerificationCode")
  public Result sendPhoneLoginVerificationCode( @RequestParam(value = "type") @ApiParam(name = "type", required = true, value = "支付业务类型") String type,
      @RequestParam(value = "phone") @ApiParam(name = "phone", required = true, value = "手机号") String phone) {
    try {
      this.paymentSmsVerification.sendVerificationCode(type,phone);
      return Result.ok("验证码发送成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
