package com.biz.crm.common.pay.business.sdk.event;

import com.biz.crm.common.pay.business.sdk.dto.PayEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * @author HanJiaJun
 * @describe: 支付操作事件监听器，对外
 * @createTime 2022年09月01日 10:49:00
 */
public interface PayEventListener extends NebulaEvent {
  /**
   * 未支付
   *
   * @param dto
   */
  void onUnpaid(PayEventDto dto);

  /**
   * 在处理
   *
   * @param dto
   */
  void onProcessing(PayEventDto dto);

  /**
   * 成功
   *
   * @param dto
   */
  void onSuccess(PayEventDto dto);

  /**
   * 在失败
   *
   * @param dto
   */
  void onFailure(PayEventDto dto);

  /**
   * 在关闭
   *
   * @param dto
   */
  void onClose(PayEventDto dto);
}
