package com.biz.crm.common.pay.business.sdk.dto;

import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * @author HanJiaJun
 * @describe: 支付操作事件 DTO
 * @createTime 2022年09月01日 10:53:00
 */
@Data
public class PayEventDto implements NebulaEventDto {
  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 操作类型
   */
  @ApiModelProperty("操作类型")
  private String operationType;

  /**
   * 关联单据号
   */
  @ApiModelProperty("关联单据号")
  private String relationshipDocNumber;

  /**
   * 金额
   */
  @ApiModelProperty("金额")
  private BigDecimal amount;

  /**
   * 操作时间
   */
  @ApiModelProperty("操作时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date operationTime;
}
