package com.biz.crm.common.pay.support.cpcn.config;


import com.biz.crm.common.pay.support.cpcn.strategy.transfer.convertor.Aggregate7Wechat7ForwardConvertor;
import com.biz.crm.common.pay.support.cpcn.strategy.transfer.convertor.Redirect7Wechat7AppletConvertor;
import com.biz.crm.common.pay.support.cpcn.strategy.transfer.convertor.Scan7Aggregate7ForwardConvertor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

/**
 * 支付cpcn配置
 *
 * @author hefan
 * @date 2022/08/22
 */
@Configuration
@ComponentScan(basePackages = "com.biz.crm.common.pay.support.cpcn")
public class PayCpcnConfig {

  /**
   * 转换器：聚合支付&微信&正扫
   *
   * @return {@link Aggregate7Wechat7ForwardConvertor}
   */
  @Bean
  @ConditionalOnMissingBean
  public Aggregate7Wechat7ForwardConvertor getAggregateConvertor() {
    return new Aggregate7Wechat7ForwardConvertor();
  }

  /**
   * 转换器：条码支付&聚合码&正扫
   *
   * @return {@link Scan7Aggregate7ForwardConvertor}
   */
  @Bean
  @ConditionalOnMissingBean
  public Scan7Aggregate7ForwardConvertor getScan1Aggregate1ForwardConvertor() {
    return new Scan7Aggregate7ForwardConvertor();
  }

  /**
   * 转换器：跳转支付&微信&小程序
   *
   * @return {@link Redirect7Wechat7AppletConvertor}
   */
  @Bean
  @ConditionalOnMissingBean
  public Redirect7Wechat7AppletConvertor getRedirect7Wechat7AppletConvertor() {
    return new Redirect7Wechat7AppletConvertor();
  }




}
