package com.biz.crm.common.pay.support.cpcn.base.common.http.internal;

import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpConnection;
import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpData;
import com.biz.crm.common.pay.support.cpcn.base.common.http.NameValuePair;
import com.biz.crm.common.pay.support.cpcn.base.common.http.ResponseDgtEnvlp;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicHeader;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

/**
 * 基于httpclient的httpconention实现
 *
 * @author Keller
 */
@Slf4j
@Setter
public class HttpClientConnection implements HttpConnection {
  /**
   * 网络请求连接超时
   */
  private int connectTimeout = 50000;
  /**
   * 网络请求读取数据超时
   */
  private int readTimeout = 50000;
  /**
   * 输出字符编码
   */
  private String outputCharset = "UTF-8";
  /**
   * 输入字符编码
   */
  private String inputCharset = "UTF-8";
  /**
   * 请求头媒体类型
   */
  private String contentType = "application/x-www-form-urlencoded";

  /**
   * 通过list形式参数执行请求
   *
   * @param list
   * @return
   */
  @Override
  public String execute(String uri, List<NameValuePair> list) {
    HttpData httpData = new HttpData(list, this.outputCharset);
    String request = httpData.getData();
    return execute(uri, request);
  }

  @Override
  public ResponseDgtEnvlp executeRequest(String uri, List<NameValuePair> list) {
    HttpData httpData = new HttpData(list, this.outputCharset);
    String request = httpData.getData();
    HttpResponse httpResponse = this.sendPost(uri, request);

    HttpEntity httpEntity = httpResponse.getEntity();
    Validate.notNull(httpEntity, "httpclient请求返回为空，请检查请求地址！");

    String response = null;
    try (InputStream inputStream = httpEntity.getContent()) {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      byte[] buffer = new byte[1024];
      int num = inputStream.read(buffer);
      while (num != -1) {
        baos.write(buffer, 0, num);
        num = inputStream.read(buffer);
      }
      baos.flush();
      response = (baos.toString(this.inputCharset)).trim();
    } catch (IOException e) {
      log.error("httpclient 请求错误", e);
      throw new RuntimeException(e);
    }
    ResponseDgtEnvlp responseDgtEnvlp = new ResponseDgtEnvlp();
    responseDgtEnvlp.setResponsetext(response);
    if (httpResponse.getFirstHeader("isDgEnv") != null) {
      responseDgtEnvlp.setIsDgEnv(httpResponse.getFirstHeader("isDgEnv").getValue());
    }
    if (httpResponse.getFirstHeader("digitalEnvelope") != null) {
      responseDgtEnvlp.setDgtlEnvlp(httpResponse.getFirstHeader("digitalEnvelope").getValue());
    }
    if (httpResponse.getFirstHeader("signAlgorithm") != null) {
      responseDgtEnvlp.setSignAlgorithm(httpResponse.getFirstHeader("signAlgorithm").getValue());
    }
    if (httpResponse.getFirstHeader("encryptSN") != null) {
      responseDgtEnvlp.setEncryptSN(httpResponse.getFirstHeader("encryptSN").getValue());
    }
    if (httpResponse.getFirstHeader("signSN") != null) {
      responseDgtEnvlp.setSignSN(httpResponse.getFirstHeader("signSN").getValue());
    }
    return responseDgtEnvlp;
  }

  /**
   * 发送post请求
   * @param uri
   * @param request
   * @return
   */
  private HttpResponse sendPost(String uri, String request){
    HttpClientBuilder clientBuilder = HttpClientBuilder.create();
    Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory>create()
                                                     .register("http", new PlainConnectionSocketFactory())
                                                     .build();
    clientBuilder.setConnectionManager(new PoolingHttpClientConnectionManager(registry));
    RequestConfig requestConfig = RequestConfig.custom().
                                      setConnectTimeout(connectTimeout).
                                      setConnectTimeout(readTimeout).setSocketTimeout(50000).build();
    clientBuilder.setDefaultRequestConfig(requestConfig);
    CloseableHttpClient httpClient = clientBuilder.build();
    HttpPost httpPost = new HttpPost(uri);
    BasicHeader basicHeader = new BasicHeader("Content-Type", contentType);
    httpPost.addHeader(basicHeader);
    HttpEntity httpEntity = null;
    try {
      StringEntity stringEntity = new StringEntity(request, ContentType.APPLICATION_FORM_URLENCODED.withCharset(outputCharset));
      httpPost.setEntity(stringEntity);
      CloseableHttpResponse closeableHttpResponse = httpClient.execute(httpPost);
      Validate.notNull(closeableHttpResponse != null && closeableHttpResponse.getEntity() != null ,"httpclient请求返回为空，请检查请求地址！");
      return closeableHttpResponse;
    } catch (IOException e) {
      log.error("httpclient 请求错误", e);
      throw new RuntimeException(e);
    }
  }

  @Override
  public String execute(String uri, String request) {
    HttpClientBuilder clientBuilder = HttpClientBuilder.create();
    Registry<ConnectionSocketFactory> registry = RegistryBuilder.<ConnectionSocketFactory>create()
            .register("http", new PlainConnectionSocketFactory())
            .build();
    clientBuilder.setConnectionManager(new PoolingHttpClientConnectionManager(registry));
    RequestConfig requestConfig = RequestConfig.custom().
            setConnectTimeout(connectTimeout).
            setConnectTimeout(readTimeout).setSocketTimeout(50000).build();
    clientBuilder.setDefaultRequestConfig(requestConfig);
    CloseableHttpClient httpClient = clientBuilder.build();
    HttpPost httpPost = new HttpPost(uri);
    BasicHeader basicHeader = new BasicHeader("Content-Type", contentType);
    httpPost.addHeader(basicHeader);
    String response = null;
    HttpEntity httpEntity = null;
    try {
      StringEntity stringEntity = new StringEntity(request, ContentType.APPLICATION_FORM_URLENCODED.withCharset(outputCharset));
      httpPost.setEntity(stringEntity);
      CloseableHttpResponse closeableHttpResponse = httpClient.execute(httpPost);
      httpEntity = closeableHttpResponse.getEntity();
    } catch (IOException e) {
      log.error("httpclient 请求错误", e);
      throw new RuntimeException(e);
    }
    Validate.notNull(httpEntity, "httpclient请求返回为空，请检查请求地址！");
    try (InputStream inputStream = httpEntity.getContent()) {
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      byte[] buffer = new byte[1024];
      int num = inputStream.read(buffer);
      while (num != -1) {
        baos.write(buffer, 0, num);
        num = inputStream.read(buffer);
      }
      baos.flush();
      response = (baos.toString(this.inputCharset)).trim();
    } catch (IOException e) {
      log.error("httpclient 请求错误", e);
      throw new RuntimeException(e);
    }
    return response;
  }
}
