package com.biz.crm.common.pay.support.cpcn.base.cpcn.notice;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import lombok.Getter;
import lombok.ToString;
import org.w3c.dom.Document;

/**
 * 4658-充值/提现/代付结果通知
 *
 * @author Keller
 */
@Getter
@ToString
public class Notice4658Request {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 原业务交易流水号
   */
  private String sourceTxSN;
  /**
   * 原业务交易编码:
   *
   * 4641=充值
   * 4643=提现
   * 4645=代付
   * 4651=转账充值
   */
  private String sourceTxCode;
  /**
   * 交易金额，单位: 分
   */
  private String amount;
  /**
   * 交易状态:
   *
   * 30=成功
   * 40=失败
   */
  private String status;
  /**
   * 用户 ID
   */
  private String userID;
  /**
   * 支付方式:
   *
   * 10=快捷支付
   * 20=网银支付
   * 40=聚合支付
   * 50=转账充值
   * 80=跳转支付
   */
  private String paymentWay;
  /**
   * 实际支付方式
   * 快捷支付:11=个人
   * 网银支付字段: <BankAccountType>
   * 聚合支付字段: <QRPaymentType>
   * 跳转支付字段: <PayWay>
   */
  private String actualPaymentWay;
  /**
   * 实际支付类型
   * 快捷支付:10=借记卡
   * 网银支付:10=借记卡
   * 聚合支付字段: <QRPaymentWay>
   * 跳转支付字段: <PayType>
   */
  private String actualPaymentType;
  /**
   * 响应时间
   */
  private String responseTime;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;
  /**
   * 绑卡流水号
   */
  private String bindingTxSN;
  /**
   * 提现方式
   *
   * 0-接口提现
   * 1-商户服务系统提现
   * 2-自动提现
   */
  private String withdrawalType;
  /**
   * 备注
   */
  private String remark;
  /**
   * 实际支付卡类型:
   *
   * 10=余额
   * 20=借记卡
   * 40=未知
   */
  private String cardType;
  /**
   * 付款人账户号码
   */
  private String payerBankAccountNumber;
  /**
   * 付款人账户名称
   */
  private String payerBankAccountName;
  /**
   * 收款人账户号码
   */
  private String payeeBankAccountNumber;
  /**
   * 收款人账户名称
   */
  private String payeeBankAccountName;

  public Notice4658Request(Document document) throws Exception {
    this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
    this.sourceTxSN = XmlUtils.getNodeText(document, "SourceTxSN");
    this.sourceTxCode = XmlUtils.getNodeText(document, "SourceTxCode");
    this.amount = XmlUtils.getNodeText(document, "Amount");
    this.status = XmlUtils.getNodeText(document, "Status");
    this.userID = XmlUtils.getNodeText(document, "UserID");
    this.paymentWay = XmlUtils.getNodeText(document, "PaymentWay");
    this.actualPaymentWay = XmlUtils.getNodeText(document, "ActualPaymentWay");
    this.actualPaymentType = XmlUtils.getNodeText(document, "ActualPaymentType");
    this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
    this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
    this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    this.bindingTxSN = XmlUtils.getNodeText(document, "BindingTxSN");
    this.withdrawalType = XmlUtils.getNodeText(document, "WithdrawalType");
    this.remark = XmlUtils.getNodeText(document, "Remark");
    this.cardType = XmlUtils.getNodeText(document, "CardType");
    this.payerBankAccountNumber = XmlUtils.getNodeText(document, "PayerBankAccountNumber");
    this.payerBankAccountName = XmlUtils.getNodeText(document, "PayerBankAccountName");
    this.payeeBankAccountNumber = XmlUtils.getNodeText(document, "PayeeBankAccountNumber");
    this.payeeBankAccountName = XmlUtils.getNodeText(document, "PayeeBankAccountName");
  }
}
