package com.biz.crm.common.pay.support.cpcn.base.cpcn.notice;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import lombok.Getter;
import lombok.ToString;
import org.w3c.dom.Document;

/**
 * 5018-支付通知
 * 
 * @author Keller
 */
@Getter
@ToString
public class Notice5018Request {
  /**
   * 机构编号
   */
  private String institutionID;
  /**
   * 订单号
   */
  private String orderNo;
  /**
   * 支付流水号
   */
  private String txSN;
  /**
   * 支付金额
   * 单位:分
   */
  private String amount;
  /**
   * 可用分账金额
   * 单位: 分
   *
   * 可用分账金额等于支付金额减去已分账总金额
   */
  private String availableSplitAmount;
  /**
   * 支付状态:
   *
   * 10=未支付
   * 20=支付处理中
   * 30=支付成功
   * 40=支付失败
   * 50=订单关闭
   *
   * 过订单时效未发起支付状态为 50
   */
  private String status;
  /**
   * 支付方式:
   *
   * 00=余额支付
   * 02=信用支付
   * 10=快捷支付
   * 11=信用卡分期(快捷)
   * 20=网银支付
   * 30=代收支付
   * 40=聚合支付 (停止接入新商户)
   * 42=条码支付
   * 50=O2O
   * 60=POS (暂不支持)
   * 80=跳转支付
   * 81=信用卡分期(银联 H5)
   * 90=外卡收单
   */
  private String paymentWay;
  /**
   * 收款用户手续费总金额, 单位:分
   */
  private String payeeUserFee;
  /**
   * 付款人手续费总金额,单 位:分
   */
  private String payerUserFee;
  /**
   * 聚合支付类型:
   *
   * 10=微信
   * 20=支付宝
   * 30=银联
   * 40=聚合码
   *
   * PaymentWay=40 和 42 时非空
   */
  private String qRPaymentType;
  /**
   * 聚合支付方式:
   *
   * 41=正扫
   * 42=反扫
   * 43=公众号 (服务窗)
   * 44=小程序
   * 45=H5
   * 46=APP
   *
   * PaymentWay=40 和 42 时非空
   */
  private String qRPaymentWay;
  /**
   * 支付类型:21-2B2C,22-B2B
   */
  private String orderType;
  /**
   * 收款人用户id
   */
  private String payeeUserID;
  /**
   * 收款人名称
   */
  private String payeeName;
  /**
   * 收款人账号
   */
  private String payeeAccountNumber;
  /**
   * 实际支付银行卡类型:
   *
   * 10=余额
   * 20=借记卡
   * 30=贷记卡
   * 40=其他
   */
  private String actualPayType;
  /**
   * 申码系统流水号
   */
  private String applyCodeNO;
  /**
   * 支付回单流水号
   */
  private String bankTraceNo;
  /**
   * 平台订单号
   */
  private String traceNo;
  /**
   * 付款银行
   */
  private String bankID;
  /**
   * 付款账户名称
   */
  private String payerAccountName;
  /**
   * 付款账户号码
   */
  private String payerAccountNumber;
  /**
   * 分支行
   */
  private String payerBranchName;
  /**
   * 省
   */
  private String payerProvince;
  /**
   * 城市
   */
  private String payerCity;
  /**
   * 分期银行
   */
  private String installmentBankID;
  /**
   * 分期期数
   */
  private String installmentPeriods;
  /**
   * 失效时间
   */
  private String expireTime;
  /**
   * 付款用户 ID
   *
   * PaymentWay=40、42 和 80时返回,
   * ActualPayType=10 时,为微信的 openid;
   */
  private String payerID;
  /**
   * 际支付方式为微信，支付时为微信的子商户appid下用户唯一标识。
   */
  private String subOpenID;
  /**
   * 实际支付银行卡类型:
   *
   * 10=余额
   * 20=借记卡
   * 30=贷记卡
   * 40=其他
   */
  private String actualCardType;
  /**
   * 转账识别码
   */
  private String udID;
  /**
   * 用信申请URL
   */
  private String creditPayURL;
  /**
   * 响应时间
   */
  private String responseTime;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;

  public Notice5018Request(Document document) throws Exception {
    this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
    this.orderNo = XmlUtils.getNodeText(document, "OrderNo");
    this.txSN = XmlUtils.getNodeText(document, "TxSN");
    this.amount = XmlUtils.getNodeText(document, "Amount");
    this.status = XmlUtils.getNodeText(document, "Status");
    this.availableSplitAmount = XmlUtils.getNodeText(document, "AvailableSplitAmount");
    this.paymentWay = XmlUtils.getNodeText(document, "PaymentWay");
    this.payeeUserFee = XmlUtils.getNodeText(document, "PayeeUserFee");
    this.payerUserFee = XmlUtils.getNodeText(document, "PayerUserFee");
    this.qRPaymentType = XmlUtils.getNodeText(document, "QRPaymentType");
    this.qRPaymentWay = XmlUtils.getNodeText(document, "QRPaymentWay");
    this.orderType = XmlUtils.getNodeText(document, "OrderType");
    this.payeeUserID = XmlUtils.getNodeText(document, "PayeeUserID");
    this.payeeName = XmlUtils.getNodeText(document, "PayeeName");
    this.payeeAccountNumber = XmlUtils.getNodeText(document, "PayeeAccountNumber");
    this.actualPayType = XmlUtils.getNodeText(document, "ActualPayType");
    this.applyCodeNO = XmlUtils.getNodeText(document, "ApplyCodeNO");
    this.bankTraceNo = XmlUtils.getNodeText(document, "BankTraceNo");
    this.traceNo = XmlUtils.getNodeText(document, "TraceNo");
    this.bankID = XmlUtils.getNodeText(document, "BankID");
    this.payerAccountName = XmlUtils.getNodeText(document, "PayerAccountName");
    this.payerAccountNumber = XmlUtils.getNodeText(document, "PayerAccountNumber");
    this.payerBranchName = XmlUtils.getNodeText(document, "PayerBranchName");
    this.payerProvince = XmlUtils.getNodeText(document, "PayerProvince");
    this.payerCity = XmlUtils.getNodeText(document, "PayerCity");
    this.installmentBankID = XmlUtils.getNodeText(document, "InstallmentBankID");
    this.installmentPeriods = XmlUtils.getNodeText(document, "InstallmentPeriods");
    this.expireTime = XmlUtils.getNodeText(document, "ExpireTime");
    this.payerID = XmlUtils.getNodeText(document, "PayerID");
    this.subOpenID = XmlUtils.getNodeText(document, "SubOpenID");
    this.actualCardType = XmlUtils.getNodeText(document, "ActualCardType");
    this.udID = XmlUtils.getNodeText(document, "UdID");
    this.creditPayURL = XmlUtils.getNodeText(document, "CreditPayURL");
    this.responseTime = XmlUtils.getNodeText(document, "ResponseTime");
    this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
    this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
  }
}
