package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.internal.NilNoticeStrategy;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * 回调响应策略处理管理器
 *
 * @author Keller
 */
@Component
@AllArgsConstructor
public class NoticeManager{
  /**
   * 回调策略容器
   */
  private List<NoticeStrategy> STRATEGYS;
  /**
   * 空策略执行器
   */
  private NilNoticeStrategy nilNoticeStrategy;

  /**
   * 根据接口编号获取对应的处理策略
   *
   * @param code
   * @return
   */
  public NoticeStrategy getHandler(String code) {
    Optional<NoticeStrategy> optional = STRATEGYS.stream().filter(item -> Objects.equals(item.getCode(), code)).findFirst();
    return optional.orElse(nilNoticeStrategy);
  }
}
