package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 * 4611-绑卡 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx4611Response extends TxBaseResponse {
  /**
   * 打款截止日期; yyyyMMdd
   */
  private String deadLine;
  /**
   * 银行账户绑定流水号
   */
  private String bindingTxSN;
  /**
   * 状态:
   *
   * 10=处理中
   * 15=待短信验证
   * 17=待被动打款验证
   * 18=被动已打款待验证
   * 30=成功
   * 40=失败
   */
  private String status;
  /**
   * 线下转账充值开通状态:
   * 10=处理中
   * 20=成功
   * 30=失败
   *
   * 注:绑卡、升级时&亿联银行开通线下转账充值功能时出现，不为空。
   */
  private String transferChargeStatus;
  /**
   * 响应码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;
  /**
   * 一键绑卡行方跳转地址
   */
  private String bankRedirctForm;

  public Tx4611Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.deadLine = XmlUtils.getNodeText(document, "DeadLine");
      this.bindingTxSN = XmlUtils.getNodeText(document, "BindingTxSN");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.transferChargeStatus = XmlUtils.getNodeText(document, "TransferChargeStatus");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
      this.bankRedirctForm = XmlUtils.getNodeText(document, "BankRedirctForm");
    }
  }
}
