/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.NoticeService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeManager;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.RemoteManager;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.RemoteStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.NoticeInfo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class NoticeServiceImpl
implements NoticeService {
    private static final Logger log = LoggerFactory.getLogger(NoticeServiceImpl.class);
    @Autowired
    private NoticeManager noticeManager;
    @Autowired
    private CpcnConfig cpcnConfig;
    @Autowired
    private RemoteManager remoteManager;

    @Override
    public void handlerNotice(NoticeInfo info) {
        try {
            log.info("\u4e2d\u91d1\u539f\u59cb\u4fe1\u606f:{}", (Object)info.getMessage());
            log.info("\u4e2d\u91d1\u539f\u59cb\u7b7e\u540d:{}", (Object)info.getSignature());
            NoticeRequest noticeRequest = new NoticeRequest(info.getMessage(), info.getSignature(), this.cpcnConfig);
            this.remoteNotice(info, noticeRequest);
            log.info("\u4e2d\u91d1\u56de\u8c03\u4fe1\u606f:{}", (Object)noticeRequest.getPlainText());
            NoticeStrategy service = this.noticeManager.getHandler(noticeRequest.getTxCode());
            Assert.notNull((Object)service, (String)String.format("\u83b7\u53d6\u4e2d\u91d1\u56de\u8c03\u5904\u7406\u5668\u4e3a\u7a7a:[%s]", noticeRequest.getTxCode()));
            service.handler(noticeRequest);
            log.info("\u4e2d\u91d1\u56de\u8c03\u5904\u7406\u7ed3\u675f\uff1a{}", (Object)noticeRequest.toString());
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u4e2d\u91d1\u56de\u8c03\u6570\u636e\u51fa\u73b0\u9519\u8bef", (Throwable)e);
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    private void remoteNotice(NoticeInfo noticeInfo, NoticeRequest noticeRequest) {
        try {
            List<RemoteStrategy> remoteStrategys = this.remoteManager.getHandler(noticeRequest.getTxCode());
            if (CollectionUtils.isEmpty(remoteStrategys)) {
                return;
            }
            for (RemoteStrategy remoteStrategy : remoteStrategys) {
                remoteStrategy.handler(noticeInfo);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

