package com.biz.crm.common.pay.support.cpcn.base.common.utils;

import cfca.sadk.org.bouncycastle.jce.provider.BouncyCastleProvider;
import cfca.sadk.util.Base64;
import org.apache.commons.lang3.StringUtils;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.Provider;
import java.security.Security;

/**
 * AES256 加密工具类
 *
 * @author Keller
 */
public final class Aes256Utils {

  private Aes256Utils() {
    throw new UnsupportedOperationException("静态工具类，不支持实例化");
  }

  public static boolean initialized = false;

  public static final String ALGORITHM = "AES/ECB/PKCS7Padding";

  static {
    Security.addProvider((Provider)new BouncyCastleProvider());
  }

  public static String encode(String str, String key) throws Exception {
    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");
    SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
    cipher.init(1, keySpec);
    byte[] result = cipher.doFinal(str.getBytes(StandardCharsets.UTF_8));
    return new String(Base64.encode(result));
  }

  public static String decodeNotNull(String encode, String key) throws Exception {
    if (StringUtils.isEmpty(encode)) {
      return "";
    }
    return decode(encode, key);
  }

  public static String decode(String encode, String key) throws Exception {
    byte[] resByte = Base64.decode(encode);
    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");
    SecretKeySpec keySpec = new SecretKeySpec(PayUtils.hex2bytes(key), "AES");
    cipher.init(2, keySpec);
    byte[] decoded = cipher.doFinal(resByte);
    return new String(decoded, "UTF-8");
  }

  public static byte[] decodeForFile(byte[] encode, String key) throws Exception {
    Cipher cipher = Cipher.getInstance("AES/ECB/PKCS7Padding", "BC");
    SecretKeySpec keySpec = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), "AES");
    cipher.init(2, keySpec);
    return cipher.doFinal(encode);
  }

  public static void main(String[] args) throws Exception {
    String plain = "aaaa";
    String key = "8745B802A2C86F61F88EDE33FA984E18";
    String encode = encode(plain, key);
    String aa = decode(encode, key);
  }

}
