package com.biz.crm.common.pay.support.cpcn.base.common.utils;

import org.apache.commons.lang3.StringUtils;

/**
 * 数字信封工具类
 *
 * @author Keller
 */
public final class DgEnvUtils {
  /**
   * AES加解密类型
   */
  private static String AES_TYPE = "01";
  /**
   * SM4加解密类型
   */
  private static String SM4_TYPE = "02";
  /**
   * 交易成功返回code
   */
  private static String SUCCESS_CODE = "0";

  private DgEnvUtils() {
    throw new UnsupportedOperationException("静态工具类，不支持实例化");
  }

  /**
   * 生成明文信息
   *
   * @param strs
   * @param cipherText
   * @return
   * @throws Exception
   */
  public static String generatePlainText(String[] strs, String cipherText) throws Exception {
    String plainText = null;
    if (AES_TYPE.equals(strs[0])) {
      plainText = Aes128Utils.decrypt(cipherText, strs[1]);
    } else if (SM4_TYPE.equals(strs[0])) {
      plainText = SM4Utils.decrypt(cipherText, strs[1]);
    } else {
      return "";
    }
    return plainText;
  }

  /**
   * 交易结果判断
   *
   * @param response
   * @return
   * @throws Exception
   */
  public static boolean dealResponse(String response) throws Exception {
    if (StringUtils.isBlank(response)) {
      return false;
    }
    String errorCode = XmlUtils.getNodeText(response, "ErrorCode");
    if (SUCCESS_CODE.equals(errorCode)) {
      return true;
    }
    return false;
  }

//  public static String decryptResponse(String symEncryptMsg, String dgtlEnvlp, String signSN, String encryptSN) throws Exception {
//    signSN = signSN.toUpperCase();
//    encryptSN = encryptSN.toUpperCase();
//    String institution = SignatureFactory.getInstitutionID(encryptSN);
//    Signer signer = SignatureFactory.getSigner(institution);
//    Validate.notNull(signer, "错误的singSN:【%s】", encryptSN);
//    String responseMessage = signer.decrypt(symEncryptMsg, dgtlEnvlp);
//    return responseMessage;
//  }
}
