package com.biz.crm.common.pay.support.cpcn.base.common.utils;

import cfca.sadk.algorithm.common.Mechanism;
import cfca.sadk.algorithm.common.PKIException;
import cfca.sadk.lib.crypto.JCrypto;
import cfca.sadk.lib.crypto.Session;
import cfca.sadk.util.EncryptUtil;
import lombok.extern.slf4j.Slf4j;

import javax.crypto.spec.SecretKeySpec;
import java.nio.charset.StandardCharsets;
import java.security.Key;

/**
 * SM4 加密工具类
 *
 * @author Keller
 */
@Slf4j
public final class SM4Utils {

  private SM4Utils() {
    throw new UnsupportedOperationException("静态工具类，不支持实例化");
  }

  private static final Mechanism SM4_ECB_ME = new Mechanism("SM4/ECB/PKCS7Padding");
  private static Session session;

  static {
    try {
      JCrypto.getInstance().initialize("JSOFT_LIB", (Object)null);
      session = JCrypto.getInstance().openSession("JSOFT_LIB");
    } catch (PKIException e) {
      log.error(e.getMessage(),e);
    }

  }

  public static String encrypt(String plainText, String key) throws Exception {
    return encrypt(plainText.getBytes(), key);
  }

  public static String encrypt(byte[] plainText, String key) throws Exception {
    return new String(EncryptUtil.encryptMessageBySM4(plainText, key), StandardCharsets.UTF_8);
  }

  public static String decrypt(String cipherText, String key) throws Exception {
    return decrypt(cipherText.getBytes(), key);
  }

  public static String decrypt(byte[] cipherText, String key) throws Exception {
    return new String(EncryptUtil.decryptMessageBySM4(cipherText, key), StandardCharsets.UTF_8);
  }

  public static String decryptByECB(String message, byte[] keyBytes) throws Exception {
    byte[] messageBytes = message.getBytes("UTF-8");
    Key key = new SecretKeySpec(keyBytes, "SM4");
    byte[] base64Bytes = EncryptUtil.decrypt(SM4_ECB_ME, key, messageBytes, session);
    return new String(base64Bytes, "UTF-8");
  }

  public static String encryptByECB(String message, String symmetricCipher) throws Exception {
    byte[] symmetricCipherBytes = symmetricCipher.getBytes("UTF-8");
    byte[] messageBytes = message.getBytes("UTF-8");
    Key key = new SecretKeySpec(symmetricCipherBytes, "SM4");
    byte[] base64Bytes = EncryptUtil.encrypt(SM4_ECB_ME, key, messageBytes, session);
    return new String(base64Bytes, "UTF-8");
  }
}
