package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.Notice4668Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.notifier.Notice4668Listener;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 4668-白名单开通/注销通知
 * <pre>
 *   机构系统发起 4665白名单开通/注销请求后，后续如果白名单状态变更为 20-启用或者 30-时效，
 *   支付平台会向机构系统在上线申请时提供的后台通知地址发送该笔白名单状态变更通知。
 *   机构系统收到该通知后需要给支付平台返回特定的响应，
 *   如果支付平台在 5 秒内未收到机构系统返回的通知响应或接收到的响应内容与规定内容不符，
 *   支付平台会认为机构系统未成功收到该通知，这时支付平台会向机构系统补发通知，最多补发两次，共发三次。
 * </pre>
 *
 * @author Keller
 */
@Slf4j
@Component
public class Notice4668Strategy implements NoticeStrategy<Notice4668Request> {
  @Autowired(required = false)
  private List<Notice4668Listener> notice4668Listeners;
  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_4668.getCode();
  }

  @Override
  public Notice4668Request exchange(NoticeRequest request) throws Exception {
    return new Notice4668Request(request.getDocument());
  }

  @Override
  public void handler(NoticeRequest request) {
    try {
      Notice4668Request notice4668Request = exchange(request);
      // 事件通知
      if (!CollectionUtils.isEmpty(notice4668Listeners)) {
        for (Notice4668Listener listener : notice4668Listeners) {
          listener.onNotice(notice4668Request);
        }
      }
    } catch (Exception e) {
      log.error("白名单开通/注销通知出现错误", e);
      throw new RuntimeException(e.getLocalizedMessage());
    }
  }
}
