package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.Notice5028Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.notifier.Notice5028Listener;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 5028-退款结果通知
 * <pre>
 *   支付平台将退款请求发送到银行时，会向机构系统发送退款结果通知。
 *   该通知将退款交易(5021-退款)的退款金额、状态及时间等信息发送到机构系统(优先向 5021 接口上送的后台通知地址发送，
 *   5021 接口没有上送则 向机构系统在上线申请时提供的后台通知地址发送)。
 *   机构系统收到该通知后需要给支付平台返回特定的响应，
 *   如果支付平台在 5 秒内未收到机构系统返回的通知响应或接收到的响应内容与规定内容不符，
 *   支付平台会认为机构系统未成功收到该通知，这时支付平台会向机构系统补发通知，最多补发两次，共发三次。
 *   机构系统收到通知后可以根据通知中的状态字段同步该笔退款交易的状态，也可以通过5026-退款查询接口同步该笔退款交易的状态。
 * </pre>
 *
 * @author Keller
 */
@Slf4j
@Component
public class Notice5028Strategy implements NoticeStrategy<Notice5028Request> {
  @Autowired(required = false)
  private List<Notice5028Listener> notice5028Listeners;

  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_5028.getCode();
  }

  @Override
  public Notice5028Request exchange(NoticeRequest request) throws Exception {
    return new Notice5028Request(request.getDocument());
  }

  @Override
  public void handler(NoticeRequest request) {
    try {
      Notice5028Request notice5028Request = exchange(request);
      // 事件通知
      if (!CollectionUtils.isEmpty(notice5028Listeners)) {
        for (Notice5028Listener listener : notice5028Listeners) {
          listener.onNotice(notice5028Request);
        }
      }
    } catch (Exception e) {
      log.error("支付通知出现错误", e);
      throw new RuntimeException(e.getLocalizedMessage());
    }
  }
}
