package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.internal;

import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpData;
import com.biz.crm.common.pay.support.cpcn.base.common.http.NameValuePair;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.configuration.CpcnProperties;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote.RemoteStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.NoticeInfo;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.Validate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

/**
 * 7709-壹企付用户签约成功后台通知
 * <pre>
 *   7703-壹企付用户签约入网交易支付平台受理成功后会进行处理，
 *   签约成功后支付平台会给机构系统发送结果通知，
 *   支付平台将后台通知发送到机构在上线申请表中提供的后台通知地址。
 *   机构系统收到该通知后需要给支付平台返回固定的响应，
 *   如果支付平台在5秒内未收到机构系统返回的通知响应或者接收到的响应内容与规定内容不符，
 *   支付平台会认为机构系统未成功收到该通知，
 *   这时支付平台会向机构系统补发通知，最多补发两次，共发三次。
 * </pre>
 *
 * @author Keller
 */
@Slf4j
@Component
public class Remote7709Strategy implements RemoteStrategy {
  @Autowired
  private CpcnProperties cpcnProperties;
  @Autowired
  private CloseableHttpClient client;

  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_7709.getCode();
  }

  @Override
  @Async("defaultRemoteNoticeExecutor")
  public void handler(NoticeInfo info) {
    if (ArrayUtils.isNotEmpty(cpcnProperties.getRemoteUrl())) {
      NameValuePair message = new NameValuePair("message", info.getMessage());
      NameValuePair signature = new NameValuePair("signature", info.getSignature());
      List<NameValuePair> params = Lists.newArrayList(message, signature);
      String[] urls = cpcnProperties.getRemoteUrl();
      for (String remoteUrl : urls) {
        try {
          String response = execute(remoteUrl, params);
          log.info("调用应用接口 :'{}',返回结果为:'{}'", remoteUrl, response);
        } catch (Exception e) {
          log.error(e.getMessage(), e);
          continue;
        }
      }
    } else {
      log.info("未配置转发地址，7709响应请求未转发");
    }
  }

  private String execute(String uri, List<NameValuePair> list) {
    HttpData httpData = new HttpData(list, "UTF-8");
    String request = httpData.getData();
    HttpPost httpPost = new HttpPost(uri);
    BasicHeader basicHeader = new BasicHeader("Content-Type", "application/x-www-form-urlencoded");
    httpPost.addHeader(basicHeader);
    String response = null;
    HttpEntity httpEntity = null;
    try {
      StringEntity stringEntity = new StringEntity(request, Charset.forName("UTF-8"));
      httpPost.setEntity(stringEntity);
      CloseableHttpResponse closeableHttpResponse = client.execute(httpPost);
      httpEntity = closeableHttpResponse.getEntity();
      Validate.notNull(httpEntity, "httpclient请求返回为空，请检查请求地址！");
      response = EntityUtils.toString(httpEntity, Charset.forName("UTF-8"));
    } catch (IOException e) {
      log.error("httpclient 请求错误", e);
      throw new RuntimeException(e);
    }
    return response;
  }
}
