package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4611Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4611Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4611-绑卡
 *
 * <pre>
 *    4611接口用于用户添加银行电子账户绑定银行卡环节，当用户在机构系统进行银行卡绑定操作时，
 *    机构系统通过该接口将用户提交的信息发送到支付平台，支付平台收到请求后立即处理，并将处理结果实时返回给机构系统。
 *
 *    个人用户进行银行卡绑定操作时，如果支付平台受理成功，会给用户在请 求中提交的手机号发送短信验证码，
 *    当用户收到短信验证码后，机构系统通过4613接口将短信验证码提交到支付平台，支付平台验证后将银行卡绑定结果返回给机构系统。
 *
 *    企业用户进行银行卡绑定操作时，如果支付平台受理成功，会给用户在请求中提交的银行账户进行打款，用户需要在银行账户的网银里查到打款金额，
 *    机构系统通过4613接口将打款金额提交到支付平台，支付平台验证后将银行卡绑定结果返回给机构系统。
 *
 *    接口请求中包含机构编号、银行账户绑定流水号、用户ID、操作标识等必传信息。银行账户信息等根据实际业务需求选择填写，
 *    具体参考下文:“报文 结构”中的字段描述。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4611Strategy extends AbstractTxStrategy<Tx4611Request, Tx4611Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4611_REQUEST.getCode();
  }

  @Override
  public Class<Tx4611Response> getResponse() {
    return Tx4611Response.class;
  }
}
