package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4643Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4643Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 4643-提现(API)
 *
 * <pre>
 *    4643-提现接口用于银行电子账户提现环节。用户在机构系统进行银行电子账户提现操作时，
 *    机构系统通过该接口将用户提交的提现请求发送到支付平台，支付平台收到请求后立即处理，并将处理结果实时返回给机构系统。
 *
 *    该接口请求中包含机构编号、交易流水号、用户ID、已绑定银行账户流水号、提现金额等必传信息，
 *    备注字段可根据实际业务需求选择填写。
 *
 *    注:提现交易实时返回受理状态，支付平台默认 T+1 日出金(支持 T0 出金，需特殊配置)，
 *    机构系统通过4656-提现查询或 4658-提现通知接口同步提现状态。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx4643Strategy extends AbstractTxStrategy<Tx4643Request, Tx4643Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_4643_REQUEST.getCode();
  }

  @Override
  public Class<Tx4643Response> getResponse() {
    return Tx4643Response.class;
  }
}
