package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5021Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5021Response;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 5021-退款
 *
 * <pre>
 *     用户对 5011-支付(API)或 5012-支付(页面)发起退款请求时，
 *     如果支付时交易对手方是机构用户，机构系统通过该接口将退款请求发送到支付平台，支付平台同步返回退款受理状态。
 *     受理成功后，支付平台日终清算时会对该笔退款交易进行处理，若机构有足够的资金用于退款，
 *     支付平台在 T+1 日向银行发送退款请求，具体到账时间以银行处理时间为准。
 *     若机构没有足够的资金用于退款，支付平台会将该笔退款置为失败状态。
 *
 *     如果支付时交易对手方是普通用户，机构系统通过该接口将退款请求发送到支付平台，支付平台收到请求后会立即处理，
 *     并实时返回退款状态。若交易对手方的电子账户有足够的资金用于退款，支付平台会实时向银行发起退款请求，
 *     具体到账时间以银行处理时间为准。若交易对手方的电子账户没有足够的资金用于退款，支付平台会将该笔退款置为失败状态。
 *     机构发起退款交易后，可使用 5026-退款查询接口或者5028-退款结果通知接口同步退款状态。
 * </pre>
 *
 * @author Keller
 */
@Component
@Slf4j
public class Tx5021Strategy extends AbstractTxStrategy<Tx5021Request, Tx5021Response> {

  @Override
  public String getCode() {
    return CpcnRequestType.TX_5021_REQUEST.getCode();
  }

  @Override
  public Class<Tx5021Response> getResponse() {
    return Tx5021Response.class;
  }
}
