package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.Getter;
import org.w3c.dom.Document;

/**
 *  5014-订单关闭 响应报文
 *
 * @author Keller
 */
@Getter
public class Tx5014Response extends TxBaseResponse {

  private String institutionID;

  private String txSN;

  private String paymentTxSN;

  private String status;

  private String responseCode;

  private String responseMessage;

  public Tx5014Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.institutionID = XmlUtils.getNodeText(document, "InstitutionID");
      this.txSN = XmlUtils.getNodeText(document, "TxSN");
      this.paymentTxSN = XmlUtils.getNodeText(document, "PaymentTxSN");
      this.status = XmlUtils.getNodeText(document, "Status");
      this.responseCode = XmlUtils.getNodeText(document, "ResponseCode");
      this.responseMessage = XmlUtils.getNodeText(document, "ResponseMessage");
    }
  }
}
