package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.SplitItem;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.util.List;

/**
 * 5021-退款
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx5021Request extends TxBaseRequest {
  /**
   * 退款交易流水号
   */
  private String txSN;
  /**
   * 原支付交易流水号
   */
  private String paymentTxSN;
  /**
   * 原支付交易时间，格式: yyyyMMdd; 不上送只支持 一年之内的支付交易查询
   */
  private String sourceTxTime;
  /**
   * 退款方式:
   *
   * 10=退款到支付账户
   * 20=原路退款
   */
  private String refundWay;
  /**
   * 退款金额
   *
   * 单位:分，不能大于可退款金额,当需要做仅退款交易和退款加撤销交易时填写,退款金额和撤销金额至少一项为有效值
   */
  private String amount;
  /**
   * 撤销金额
   *
   * 单位:分，不能大于可用分账金额,当需要做仅撤销交易和退款加撤销交易时填写,退款金额和撤销金额至少一项为有效值
   */
  private String cancelAmount;
  /**
   * 后台通知地址
   */
  private String noticeURL;
  /**
   * 备注
   */
  private String remark;

  private List<SplitItem> splitItemsList;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element TxSN = document.createElement("TxSN");
    Element PaymentTxSN = document.createElement("PaymentTxSN");
    Element SourceTxTime = document.createElement("SourceTxTime");
    Element RefundWay = document.createElement("RefundWay");
    Element Amount = document.createElement("Amount");
    Element CancelAmount = document.createElement("CancelAmount");
    Element NoticeURL = document.createElement("NoticeURL");
    Element Remark = document.createElement("Remark");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(TxSN);
    TxSN.setTextContent(this.txSN);
    Body.appendChild(PaymentTxSN);
    PaymentTxSN.setTextContent(this.paymentTxSN);
    Body.appendChild(SourceTxTime);
    SourceTxTime.setTextContent(this.sourceTxTime);
    Body.appendChild(RefundWay);
    RefundWay.setTextContent(this.refundWay);
    Body.appendChild(Amount);
    Amount.setTextContent(this.amount);
    Body.appendChild(CancelAmount);
    CancelAmount.setTextContent(this.cancelAmount);
    Body.appendChild(NoticeURL);
    NoticeURL.setTextContent(this.noticeURL);
    Body.appendChild(Remark);
    Remark.setTextContent(this.remark);
    if (this.splitItemsList != null && CollectionUtil.isNotEmpty(splitItemsList)) {
      for (int i = 0; i < this.splitItemsList.size(); i++) {
        SplitItem splitItem = this.splitItemsList.get(i);
        Element SplitItems = document.createElement("SplitItems");
        Element SplitPaymentTxSN = document.createElement("SplitPaymentTxSN");
        Element SplitAmount = document.createElement("SplitAmount");
        Element Note = document.createElement("Note");
        Body.appendChild(SplitItems);
        SplitItems.appendChild(SplitPaymentTxSN);
        SplitPaymentTxSN.setTextContent(splitItem.getSplitPaymentTxSN());
        SplitItems.appendChild(SplitAmount);
        SplitAmount.setTextContent(splitItem.getSplitAmount());
        SplitItems.appendChild(Note);
        Note.setTextContent(splitItem.getNote());
      }
    }
    postProcess(document);
  }
}
