package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

/**
 * 4695-用户权限开通查询 请求报文
 *
 * @author hefan
 * @date 2022/08/16
 */
@Getter
@Setter
@ToString
public class Tx4695Request extends TxBaseRequest {

  /**
   * 主用户 ID
   */
  private String mainUserID;

  /**
   * 用户 ID
   */
  @NotBlank(message = "用户 ID不能为空")
  private String userID;

  /**
   * 权限类型：
   * 10-余额支付
   * 20-用户收单
   * 30-用户代付
   * 40-用户分账
   * 41-用户收款
   * 42-用户付费
   * 50-用户充值
   * 60-用户提现
   * 80-线上签约
   * 90-用户验证
   * 注意：
   * 当权限类型为空时，返回全部权限类型
   * 的开通情况；支持多个权限类型查询，
   * 英文分号“;”分隔
   */
  private String authType;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element MainUserID = document.createElement("MainUserID");
    Element UserID = document.createElement("UserID");
    Element AuthType = document.createElement("AuthType");
    document.appendChild(Request);
    Request.setAttribute("version", "2.1");
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    TxCode.setTextContent(this.txCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    Body.appendChild(MainUserID);
    MainUserID.setTextContent(this.mainUserID);
    Body.appendChild(UserID);
    UserID.setTextContent(this.userID);
    Body.appendChild(AuthType);
    AuthType.setTextContent(this.authType);
    postProcess(document);
  }

}
