package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import com.google.common.collect.Lists;
import lombok.Getter;
import lombok.Setter;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.Collection;

/**
 * 4695-用户权限开通查询
 *
 * @author hefan
 * @date 2022/08/16
 */
@Getter
public class Tx4695Response extends TxBaseResponse {

  /**
   * 主用户 ID
   */
  private String mainUserID;
  /**
   * 子用户 ID
   */
  private String userID;

  /**
   * 用户权限开通明细
   */
  private Collection<Item> item;

  public Tx4695Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
    super(responseMessage, responseSignature, cpcnConfig);
  }

  @Override
  protected void process(Document document) throws Exception {
    if (Constants.SUCCESS_CODE.equals(this.code)) {
      this.mainUserID = XmlUtils.getNodeText(document, "MainUserID");
      this.userID = XmlUtils.getNodeText(document, "UserID");
      NodeList nodeList = document.getElementsByTagName("Item");
      int len = nodeList.getLength();
      this.item = Lists.newArrayListWithCapacity(len);
      for (int i = 0; i < len; ++i) {
        Node node = nodeList.item(i);
        String authType = XmlUtils.getChildNodeText(node, "AuthType");
        String authFlag = XmlUtils.getChildNodeText(node, "AuthFlag");
        String authInfo = XmlUtils.getChildNodeText(node, "AuthInfo");
        Item item = new Item();
        item.setAuthType(authType);
        item.setAuthFlag(authFlag);
        item.setAuthInfo(authInfo);
        this.item.add(item);
      }
    }
  }

  @Getter
  @Setter
  public class Item {
    /**
     * 权限类型：
     * 10-余额支付
     * 20-用户收单
     * 30-用户代付
     * 40-用户分账
     * 41-用户收款
     * 42-用户付费
     * 50-用户充值
     * 60-用户提现
     * 80-线上签约
     * 90-用户验证
     */
    private String authType;
    /**
     * 权限开通情况：
     * 0-未开通
     * 1-已开通
     */
    private String authFlag;
    /**
     * 权限未开通原因
     * - 权限未开通时，返回
     */
    private String authInfo;
  }

}
