package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.gatheringaccredit;

import cn.hutool.core.collection.CollectionUtil;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.AttachInfo;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import javax.validation.constraints.NotBlank;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import java.util.ArrayList;

/**
 * 2734-商户进件
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class Tx2734Request extends TxBaseRequest {
  /**
   * 申请流水号
   */
  @NotBlank(message = "申请流水号不能为空")
  private String applyNo;
  /**
   * 用户ID
   *
   * 壹企付产品填写开户时上送的用户 ID
   */
  @NotBlank(message = "用户ID不能为空")
  private String userID;
  /**
   * 支付方式
   * 10=微信
   * 20=支付宝
   * 40=银联
   */
  @NotBlank(message = "支付方式不能为空")
  private String payWay;
  /**
   * 行业类别
   */
  @NotBlank(message = "行业类别不能为空")
  private String category;
  /**
   * 客服电话
   */
  private String servicePhone;
  /**
   * 平台名称
   *
   * 展示在持卡人收银台上的平台名称，可选择填 写增加一下描述，若不填写，默认企业用户 xxx，个体户 xxx
   */
  private String platformName;

  private ArrayList<AttachInfo> attachInfoList;

  @Override
  public void process() throws Exception {
    DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
    DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
    Document document = documentBuilder.newDocument();
    Element Request = document.createElement("Request");
    Element Head = document.createElement("Head");
    Element Body = document.createElement("Body");
    Element TxCode = document.createElement("TxCode");
    Element InstitutionID = document.createElement("InstitutionID");
    Element ApplyNo = document.createElement("ApplyNo");
    Element UserID = document.createElement("UserID");
    Element PayWay = document.createElement("PayWay");
    Element Category = document.createElement("Category");
    Element ServicePhone = document.createElement("ServicePhone");
    Element PlatformName = document.createElement("PlatformName");
    Element AttachInfoList = document.createElement("AttachInfoList");
    Request.setAttribute("version", "2.1");
    document.appendChild(Request);
    Request.appendChild(Head);
    Head.appendChild(TxCode);
    Request.appendChild(Body);
    Body.appendChild(InstitutionID);
    Body.appendChild(ApplyNo);
    Body.appendChild(UserID);
    Body.appendChild(PayWay);
    Body.appendChild(Category);
    Body.appendChild(ServicePhone);
    Body.appendChild(PlatformName);
    Body.appendChild(AttachInfoList);
    TxCode.setTextContent(this.txCode);
    InstitutionID.setTextContent(cpcnConfig.getInstitutionID());
    ApplyNo.setTextContent(this.applyNo);
    UserID.setTextContent(this.userID);
    PayWay.setTextContent(this.payWay);
    Category.setTextContent(this.category);
    ServicePhone.setTextContent(this.servicePhone);
    PlatformName.setTextContent(this.platformName);
    if (this.attachInfoList != null && CollectionUtil.isNotEmpty(attachInfoList)) {
      for (int i = 0; i < this.attachInfoList.size(); i++) {
        AttachInfo attachInfo = this.attachInfoList.get(i);
        Element AttachInfo = document.createElement("AttachInfo");
        Element PayType = document.createElement("PayType");
        Element AppID = document.createElement("AppID");
        Element AuthPath = document.createElement("AuthPath");
        AttachInfoList.appendChild(AttachInfo);
        AttachInfo.appendChild(PayType);
        PayType.setTextContent(attachInfo.getPayType());
        AttachInfo.appendChild(AppID);
        AppID.setTextContent(attachInfo.getAppID());
        AttachInfo.appendChild(AuthPath);
        AuthPath.setTextContent(attachInfo.getAuthPath());
      }
    }
    postProcess(document);
  }
}
