package com.biz.crm.common.pay.support.cpcn.base.cpcn.vo;

import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 分账结算域
 *
 * @author Keller
 */
@Getter
@Setter
@ToString
public class SplitItem {
  /**
   * 分账结算交易流水号
   * 调用 GUIDGenerator 类的 genGUID 方法生成流水号
   */
  private String splitTxSN;
  /**
   * 分账用户ID
   * 个人企业会员上送注册会员 ID，机构会员上送机构
   * ID
   */
  private String splitUserID;
  /**
   * 分账账户号码
   * 分账用户 ID 是机构用户时才可以填写分账账户号码，且分账号码号码只能填写结算标识
   */
  private String splitAccountNumber;
  /**
   * 绑定流水号
   * 中金存管、电子账户模式（银行存管）分账到绑定银行卡时必填
   */
  private String splitBindingTxSN;
  /**
   * 银行账户类型
   *
   * 11=个人账户
   * 12=企业账户
   * 中金存管模式分账到普通银行卡时必填
   */
  private String splitBankAccountType;
  /**
   * 银行 ID
   * 中金存管模式分账到普通银行卡时必填
   */
  private String splitBankID;
  /**
   * 银行账户名称
   * 中金存管模式分账到普通银行卡时必填
   */
  private String splitBankAccountName;
  /**
   * 银行账户号码
   * 中金存管模式分账到普通银行卡时必填
   */
  private String splitBankAccountNumber;
  /**
   * 结算金额
   *
   * 单位:分，不可为空或0
   */
  private String splitAmount;
  /**
   * 冻结金额
   *
   * 单位:分，分账到个人企业个体户支付账户并冻结时必填
   */
  private String splitFrozenAmount;

  // SplitBranchName

  // SplitProvince

  // SplitCity

  /**
   * 人民银行联行号
   */
  private String cNAPSCode;

  //DelayFundOut

  //FundOutWay

  /**
   * 分账备注
   */
  private String note;

  private String splitBusinessType;

  private String percentage;

  private String splitAccountType;
  /**
   * 分账流水号
   */
  private String sourceSplitTxSN;

  private String sourceSplitAmount;

  private String status;
  /**
   * 响应时间
   */
  private String responseTime;
  /**
   * 响应代码
   */
  private String responseCode;
  /**
   * 响应消息
   */
  private String responseMessage;
  /**
   * 原分账支付交 易流水号
   */
  private String splitPaymentTxSN;
  /**
   *交易流水号
   */
  private String txSN;
  /**
   * 分账成功时间
   */
  private String splitResponseTime;
  /**
   * 回单信息
   */
  private String receiptContent;

}
