package com.biz.crm.common.pay.support.cpcn.model;

import lombok.Data;

/**
 * 5011-支付（API）
 * - 跳转支付 关心的数据
 *
 * @author hefan
 * @date 2022/08/27
 */
@Data
public class Tx5011RedirectPayModel extends Tx5011TransferModel{
  /**
   * 商品名称
   *
   * PaymentWay=02/40/42/80 必填
   */
  private String goodsName;
  /**
   * 平台名称
   *
   * PaymentWay=80必填
   */
  private String platformName;
  /**
   * 用户 IP
   *
   * PaymentWay=80必填
   */
  private String clientIP;
  /**
   * 支付方式
   *
   * 45=H5支付 (PayType=30、31、32、33)
   * 46=APP 支付 (PayType=30、31、32、33)
   * 47=手机迷你付(PayType=33)
   * 48=手机Pay (PayType=34、35)
   * 50=JSAPI (PayType=31、32)
   * 51=小程序支付 (PayType=31)
   */
  private String payWay;
  /**
   * 支付类型
   *
   * 30=手机网银
   * 31=微信
   * 32=支付宝
   * 33=银联
   * 34=Apple Pay
   * 35=Android Pay
   */
  private String payType;
  /**
   * 发卡行
   *
   * 参考《银行编码表》 PayType=30 时必填InstallmentType=20时必填 (支付宝分期不需 要填)
   */
  private String redirectPayBankID;
  /**
   * 支付方式限制:
   *
   * 10=不限定
   * 20=仅支持借记卡
   * 30=仅支持贷记卡 (PayType=30、 PayWay=45/46时可用，并且不为空)
   * 默认值 10
   */
  private String limitPay;
  /**
   * AppID(商户进件录入)
   * 微信必填PayType=31支付宝选填(支付宝直连必填)
   */
  private String subAppID;
  /**
   * 用户ID 微信:openid 支付宝: buyer_user_id (PayWay=50/51必填)
   */
  private String subOpenID;
  /**
   * 分期控制标识 10-不指定分期 20-指定分期 PayType=32、33，PayWay=45- H5支付时必填
   */
  private String installmentType = "10";
  /**
   * 手续费收取模式:
   *
   * 10=商户贴息
   * 20=持卡人付费
   *
   * InstallmentType=20时必填
   */
  private String feeMode;
  /**
   * 支付类型为
   *
   * 33、分期控制标识为 20-指定分期必填(支付宝分期不需要填)
   */
  private String bankAccountNumber;
  /**
   * 卡号掩码
   *
   * 当为银联 H5 分期（含分期信息码）时，InstallmentForce=10时可以强制限定
   */
  private String maskAccNo;
  /**
   * 使用强制使用上送的限定信息进行分期支付
   * 10：是，强制使用限定信息进行分期支付
   * 20：否，默认展示限定信息，用户在支付时可以重选；
   *
   * PayType=33、 PayWay=45，InstallmentType=20
   * 指定分期时(银联 H5分期)必填
   */
  private String installmentForce;
  /**
   * 手机号
   */
  private String phoneNumber;
  /**
   * 是否登录,标识该用户是否已登录：
   * 10：已登录
   * 20：未登录
   *
   * PayType=33、PayWay=45，InstallmentType=20
   * 指定分期时(银联 H5分期)必填
   */
  private String loginState;
  /**
   * 分期期数 分期控制标识20指定分期时必填
   */
  private String numberOfInstallments;
  /**
   * 实名验证信息
   *
   * 保险实名认证商户必填
   */
  private String identityInfo;
  /**
   * 跳转前来源
   * 10=App,20=H5,30=公众号,40=小程序
   */
  private String redirectSource = "40";
}
