package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4695Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4695Response;
import com.biz.crm.common.pay.support.sdk.service.AccountAuthSupportVoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collection;
import java.util.Optional;

/**
 * 账户权限开通情况
 *
 * @author hefan
 * @date 2022/08/16
 */
@Service
public class AccountAuthSupportVoServiceImpl implements AccountAuthSupportVoService {

  @Autowired(required = false)
  private TxService<Tx4695Response> tx4695Service;

  @Override
  public Boolean haveAuthorityToCollectMoney(String userID, String mainUserID) {

    /**
     * 4695 接口  20-用户收单  这个权限代表可以作为5011的收款用户进行收款
     */
    Tx4695Request tx4695Request = this.getTx4695Request(userID, mainUserID, "");
    // 提交 请求到中金
    Tx4695Response tx4695Response = tx4695Service.handlerTx(CpcnRequestType.TX_4695_REQUEST.getCode(), tx4695Request);
    // 解析返回数据
    return this.haveAuthorityToCollectMoney(tx4695Response);
  }

  /**
   * 根据返回信息判断账户是否拥有收款权限
   *
   * @param response 响应
   * @return {@link Boolean}
   */
  private Boolean haveAuthorityToCollectMoney(Tx4695Response response) {
    String code = response.getCode();
    boolean isSuccess = Constants.SUCCESS_CODE.equals(code);
    if (!isSuccess) {
      return isSuccess;
    }
    Collection<Tx4695Response.Item> item = response.getItem();
    Optional<Tx4695Response.Item> first = item.stream()
        .filter(x -> x.getAuthType().equals("20"))
        .findFirst();
    Tx4695Response.Item item20 = first.get();
    String authFlag = item20.getAuthFlag();
    return authFlag.equals(BooleanEnum.TRUE.getNumStr());
  }

  /**
   * 构建 中金的4695 请求对象
   *
   * @param userID 用户id
   * @return {@link Tx4695Request}
   */
  private Tx4695Request getTx4695Request(String userID, String mainUserID, String authType) {
    Tx4695Request tx4695Request = new Tx4695Request();
    tx4695Request.setTxCode(CpcnRequestType.TX_4695_REQUEST.getCode());
    tx4695Request.setMainUserID(mainUserID);
    tx4695Request.setAuthType(authType);
    tx4695Request.setUserID(userID);
    return tx4695Request;
  }
}
