package com.biz.crm.common.pay.support.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnRequestType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4691Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount.Tx4691Response;
import com.biz.crm.common.pay.support.sdk.service.AccountBalanceSupportVoService;
import com.biz.crm.common.pay.support.sdk.vo.AccountBalanceSupportVo;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 帐户余额impl签证官支持服务
 *
 * @author hefan
 * @date 2022/08/15
 */
public class AccountBalanceSupportVoServiceImpl implements AccountBalanceSupportVoService {

  @Autowired(required = false)
  private TxService<Tx4691Response> tx4691Service;

  @Override
  public AccountBalanceSupportVo findByUserID(String userID) {
    /**
     * 暂定：使用中金 4691-用户信息查询
     */
    Tx4691Request tx4691Request = this.getTx4691Request(userID);
    // 提交 用户信息查询请求
    Tx4691Response tx4691Response = tx4691Service.handlerTx(CpcnRequestType.TX_4691_REQUEST.getCode(), tx4691Request);
    // 返回处理
    return this.parseResponse(tx4691Response);
  }

  /**
   * 解析响应
   *
   * @param response tx4691响应
   */
  private AccountBalanceSupportVo parseResponse(Tx4691Response response) {
    String code = response.getCode();
    boolean isSuccess = Constants.SUCCESS_CODE.equals(code);
    if (!isSuccess) {
      throw new RuntimeException(response.getMessage());
    }
    AccountBalanceSupportVo accountBalanceSupportVo = new AccountBalanceSupportVo();
    accountBalanceSupportVo.setUserName(response.getUserName());
    accountBalanceSupportVo.setUserID(response.getUserID());
    accountBalanceSupportVo.setParentUserID(response.getParentUserID());
    accountBalanceSupportVo.setBalance(response.getBalance());
    accountBalanceSupportVo.setReceivedBalance(response.getReceivedBalance());
    accountBalanceSupportVo.setReceivableBalance(response.getReceivableBalance());
    accountBalanceSupportVo.setFrozenAmount(response.getFrozenAmount());
    accountBalanceSupportVo.setUserType(response.getUserType());
    accountBalanceSupportVo.setStatus(response.getStatus());
    return accountBalanceSupportVo;
  }

  /**
   * 构建 中金的4691 请求对象
   *
   * @return {@link Tx4691Request}
   */
  private Tx4691Request getTx4691Request(String userID) {
    Tx4691Request tx4691Request = new Tx4691Request();
    tx4691Request.setTxCode(CpcnRequestType.TX_4691_REQUEST.getCode());
    tx4691Request.setUserID(userID);
    return tx4691Request;
  }


}
