package com.biz.crm.common.pay.support.cpcn.strategy.transfer.convertor;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.constant.Constants;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnBillTransactionStatus;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Response;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.SplitItem;
import com.biz.crm.common.pay.support.cpcn.model.Tx5011QRPayModel;
import com.biz.crm.common.pay.support.sdk.dto.transfer.PayDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.Aggregate7Wechat7Forward;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.TransferCarrier;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.convertor.TransferConvertor;
import com.biz.crm.common.pay.support.sdk.vo.transfer.QRCodeVo;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 转账转换器
 * - 聚合支付
 * - 微信
 * - 正扫
 * 数字 7 - 因为&符号在7上面，代表and的意思
 * 中金已不再支持，仅作 代码 demo示例
 *
 * @author hefan
 * @date 2022/08/25
 */
@Deprecated
public class Aggregate7Wechat7ForwardConvertor implements TransferConvertor<Tx5011Request, Tx5011Response> {

  @Autowired(required = false)
  private CpcnConfig cpcnConfig;

  @Override
  public Tx5011Request convert(TransferCarrier carrier) {
    Validate.isTrue(this.isConvertible(carrier), StringUtils.join("聚合支付", "转换器", "不可转换"));
    Aggregate7Wechat7Forward aggregate7Wechat7Forward = (Aggregate7Wechat7Forward) carrier;
    // 载体全量数据
    PayDto transferData = aggregate7Wechat7Forward.getTransferData();
    // 设置中金参数匹配具体的转账行为
    Tx5011QRPayModel model = this.getQRPayModel(transferData);
    // 转换为中金base模块可识别的业务对象
    Tx5011Request tx5011Request = this.getTx5011Request(model);
    return tx5011Request;
  }

  @Override
  public Boolean isConvertible(TransferCarrier carrier) {
    return carrier instanceof Aggregate7Wechat7Forward;
  }

  /**
   * 解析响应
   *
   * @param response 响应
   * @return {@link ResponseModel}
   */
  @Override
  public ResponseModel<QRCodeVo> parseResponse(Tx5011Response response) {
    String code = response.getCode();
    boolean isSuccess = Constants.SUCCESS_CODE.equals(code);
    if (!isSuccess) {
      throw new RuntimeException(response.getMessage());
    }
    ResponseModel responseModel = new ResponseModel();
    responseModel.setSuccess(true);
    String status = response.getStatus();
    responseModel.setMessage(response.getResponseMessage());
    boolean haveUrl = CpcnBillTransactionStatus.PROCESSING.getCode().equals(status);
    if (haveUrl) {
      // PaymentWay=40,QRPaymentWay=41，且 Status=20 时非空
      String qrCodeURL = response.getQRCodeURL();
      String qRImageURL = response.getQRImageURL();
      QRCodeVo QRCodeVo = new QRCodeVo();
      responseModel.setResponse(QRCodeVo);
      QRCodeVo.setQRCodeURL(qrCodeURL);
      QRCodeVo.setQRImageURL(qRImageURL);
    }
    return responseModel;
  }


  /**
   * 5011-支付（API）聚合支付的请求
   * - 聚合支付（微信-正扫）需要的传参
   *
   * @param dto 充值dto
   * @return {@link Tx5011QRPayModel}
   */
  private Tx5011QRPayModel getQRPayModel(PayDto dto) {
    Tx5011QRPayModel model = new Tx5011QRPayModel();
    // 40=聚合支付(停止 接入新商户)
    model.setPaymentWay("40");
    // 10 = 微信
    model.setQRPaymentType("10");
    // 41 = 正扫
    model.setQRPaymentWay("41");
    // 信用卡限制标识
    if (!dto.getQRLimitPay()) {
      model.setQRLimitPay("20");
    }
    model.setCancelPayRedirectPageURL(dto.getCancelPayRedirectPageURL());
    // 默认为公众号
    model.setQRPageUrlType(dto.getQRPageUrlType());
    model.setRedirectPageURL(dto.getRedirectPageURL());
    model.setGoodsName(dto.getGoodsName());
    model.setTxSN(dto.getTxSN());
    model.setOrderNo(dto.getOrderNo());
    model.setPayerUserID(dto.getPayerUserID());
    model.setPayeeAccountNumber(dto.getPayeeAccountNumber());
    model.setPayeeUserID(dto.getPayeeUserID());
    model.setAmount(dto.getAmount());
    model.setExpirePeriod(dto.getExpirePeriod());
    model.setPageURL(cpcnConfig.getNoticeUrl());
    model.setHasSubsequentSplit("2");
    model.setNoticeURL(cpcnConfig.getNoticeUrl());
    model.setRemark(dto.getRemark());
    return model;
  }

  /**
   * 聚合支付的请求
   * - 按照中金文档，聚合支付该做的传值校验都做了。
   * - 这是以paymentWay为维度转参
   *
   * @param model 聚合支付的请求
   * @return {@link Tx5011Request}
   */
  private Tx5011Request getTx5011Request(Tx5011QRPayModel model) {
    Tx5011Request tx5011Request = new Tx5011Request();
    // R
    tx5011Request.setTxSN(model.getTxSN());
    // 付款userID：经销商的userID
    tx5011Request.setPayerUserID(model.getPayerUserID());
    // 收款userID：品牌商的userID
    tx5011Request.setPayeeUserID(model.getPayeeUserID());
    tx5011Request.setPaymentWay(model.getPaymentWay());
    tx5011Request.setAmount(model.getAmount());
    tx5011Request.setExpirePeriod(model.getExpirePeriod());
    tx5011Request.setPageURL(model.getPageURL());
    tx5011Request.setHasSubsequentSplit(model.getHasSubsequentSplit());
    // O
    tx5011Request.setOrderNo(model.getOrderNo());
    tx5011Request.setNoticeURL(model.getNoticeURL());
    tx5011Request.setRemark(model.getRemark());
    // C
    // 因为我们都是机构内转账，所以这里也要填
    tx5011Request.setPayeeAccountNumber(model.getPayeeAccountNumber());
    // 聚合支付（必填）商品名称
    tx5011Request.setGoodsName(model.getGoodsName());

    // 后续分账：没有时（HasSubsequentSplit=1）必填 ： SplitItems {
    if (BooleanEnum.TRUE.getNumStr().equals(model.getHasSubsequentSplit())) {
      List<SplitItem> splitItems = new ArrayList<>();
      // fixme: 需要的人去实现
      tx5011Request.setSplitItemsList(splitItems);
    }
    // }

    // 支付方式：聚合支付 ：QRPay {
    // - R
    tx5011Request.setQRPaymentType(model.getQRPaymentType());
    tx5011Request.setQRPaymentWay(model.getQRPaymentWay());
    // - C
    // 反扫时，必填;
    if ("42".equals(model.getQRPaymentWay())) {
      //默认 10 = 条码支付
      tx5011Request.setPaymentScene(model.getPaymentScene());
      tx5011Request.setQRPayCode(model.getQRPayCode());
    }
    // 刷脸支付,必填
    if ("90".equals(model.getPaymentScene())) {
      tx5011Request.setPreTxSN(model.getPreTxSN());
    }
    // 公众号，小程序，必填
    if ("43".equals(model.getQRPaymentWay()) || "44".equals(model.getQRPaymentWay())) {
      tx5011Request.setOpenID(model.getOpenID());
      tx5011Request.setMerchantAppID(model.getMerchantAppID());
    }
    // APP, 必填
    if ("46".equals(model.getQRPaymentWay())) {
      tx5011Request.setMerchantAppID(model.getMerchantAppID());
    }
    // 正扫，反扫，选填
    if ("41".equals(model.getQRPaymentWay()) || "42".equals(model.getQRPaymentWay())) {
      tx5011Request.setQRLimitPay(model.getQRLimitPay());
    }
    // 支付类型 QRPaymentType=30 银联，聚合支付方式为 42-反扫时必填
    if ("30".equals(model.getQRPaymentType()) && "42".equals(model.getQRPaymentWay())) {
      tx5011Request.setTerminalID(model.getTerminalID());
    }
    // - O
    // 正扫时,填入有效; 取消支付后的前台跳转页面
    if ("41".equals(model.getQRPaymentWay())) {
      if (StringUtils.isNotBlank(model.getCancelPayRedirectPageURL())) {
        tx5011Request.setCancelPayRedirectPageURL(model.getCancelPayRedirectPageURL());
      }
      if (StringUtils.isNotBlank(model.getRedirectPageURL())) {
        tx5011Request.setRedirectPageURL(model.getRedirectPageURL());
      }
    }
    // 微信，必填；默认：公众号
    if ("10".equals(model.getQRPaymentType())) {
      tx5011Request.setQRPageUrlType(model.getQRPageUrlType());
    }
    // }

    // O
    //tx5011Request.setTerminalUserID();
    //tx5011Request.setExtension();

    // C
    //tx5011Request.setSourceTxTime();
    //tx5011Request.setPlatformName();
    //tx5011Request.setClientIP();
    //tx5011Request.setDeductionSettlementFlag();

    // 支付方式：快捷支付 ：QuickPay {
    //tx5011Request.setSMSVerification();
    //tx5011Request.setBindingTxSN();
    //tx5011Request.setInstallmentPeriods();
    //tx5011Request.setInterestType();
    //tx5011Request.setCVN2();
    //tx5011Request.setValidateDate();
    //tx5011Request.setFeeRate();
    // }

    // 支付方式：网银支付 ：EBankPay {
    //tx5011Request.setBankAccountType();
    //tx5011Request.setBankCardType();
    //tx5011Request.setBankID();
    // }


    // 支付方式：代收支付 ：Gathering {
    //tx5011Request.setBankAccountType();
    //tx5011Request.setBankCardType();
    //tx5011Request.setBankID();
    //tx5011Request.setAccountName();
    //tx5011Request.setAccountNumber();
    //tx5011Request.setIdentificationType();
    //tx5011Request.setIdentificationNumber();
    //tx5011Request.setPhoneNumber();
    //tx5011Request.setEntrustNo();
    //tx5011Request.setTokenNo();
    // }

    // 支付方式：跳转支付 ：RedirectPay {
    //tx5011Request.setPayWay();
    //tx5011Request.setPayType();
    //tx5011Request.setRedirectPayBankID();
    //tx5011Request.setLimitPay();
    //tx5011Request.setSubAppID();
    //tx5011Request.setSubOpenID();
    //tx5011Request.setInstallmentType();
    //tx5011Request.setFeeMode();
    //tx5011Request.setBankAccountNumber();
    //MaskAccNo
    //InstallmentForce
    //tx5011Request.setPhoneNumber();
    //LoginState
    //tx5011Request.setNumberOfInstallments();
    //IdentityInfo
    //tx5011Request.setRedirectSource();
    // }

    // 支付方式：条码支付 ：ScanPay {
    //tx5011Request.setScanPaymentType();
    //tx5011Request.setScanPaymentWay();
    //tx5011Request.setPaymentScene();
    //tx5011Request.setPreTxSN();
    //tx5011Request.setScanPaymentCode();
    //AccountType
    //tx5011Request.setScanPaymentLimitFlag();
    //tx5011Request.setCancelPayRedirectPageURL();
    //tx5011Request.setScanPageUrlType();
    //tx5011Request.setRedirectPageURL();
    //tx5011Request.setInstallmentType();
    //tx5011Request.setFeeMode();
    //tx5011Request.setNumberOfInstallments();
    //IdentityInfo
    //tx5011Request.setSubAppID();
    //TerminalID
    //tx5011Request.setBankID();
    // }

    // 支付方式：O2O ：O2OPay {
    //tx5011Request.setO2OPhoneNumber();
    //O2OPayerName
    // }

    // 支付方式：扫码预授权 ：AuthPay {
    //tx5011Request.setAuthTxSN();
    // }

    // 支付方式：信用支付 ：CreditPay {
    //tx5011Request.setLoanTerm();
    //tx5011Request.setRepaymentType();
    //tx5011Request.setYearlyInterestRate();
    //tx5011Request.setPaymentType();
    //ImageCreditVoucherTxSN
    //tx5011Request.setBusinessCategory();
    //tx5011Request.setContractStartDate();
    //tx5011Request.setContractEndDate();
    // }
    return tx5011Request;
  }


}
