/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.common.http.internal;

import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpData;
import com.biz.crm.common.pay.support.cpcn.base.common.http.HttpsConnection;
import com.biz.crm.common.pay.support.cpcn.base.common.http.IgnoreHostnameVerifier;
import com.biz.crm.common.pay.support.cpcn.base.common.http.NameValuePair;
import com.biz.crm.common.pay.support.cpcn.base.common.http.ResponseDgtEnvlp;
import com.biz.crm.common.pay.support.cpcn.base.common.http.SecurityContext;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.net.ssl.HttpsURLConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpsConnection
implements HttpsConnection {
    private static final Logger log = LoggerFactory.getLogger(SimpleHttpsConnection.class);
    private String method = "POST";
    private int connectTimeout = 50000;
    private int readTimeout = 50000;
    private boolean useDefaultSSLSocketFactory = true;
    private String contentType = "application/x-www-form-urlencoded";
    private boolean ignoreHostname = true;

    @Override
    public String execute(String uri, List<NameValuePair> list) {
        HttpData httpData = new HttpData(list, StandardCharsets.UTF_8.name());
        String request = httpData.getData();
        String response = this.execute(uri, request);
        return response;
    }

    @Override
    public ResponseDgtEnvlp executeRequest(String uri, List<NameValuePair> list) {
        return null;
    }

    @Override
    public String execute(String uri, String request) {
        String response;
        HttpsURLConnection httpsUrlConnection;
        log.info("\u8bf7\u6c42uri: '{}', \u8bf7\u6c42\u53c2\u6570'{}'", (Object)uri, (Object)request);
        try {
            URL url = new URL(uri);
            httpsUrlConnection = (HttpsURLConnection)url.openConnection();
        }
        catch (IOException e) {
            throw new RuntimeException("\u521d\u59cb\u5316\u7f51\u7edc\u8fde\u63a5\u9519\u8bef", e);
        }
        if (!this.useDefaultSSLSocketFactory) {
            httpsUrlConnection.setSSLSocketFactory(SecurityContext.sslSocketFactory);
        }
        if (this.ignoreHostname) {
            httpsUrlConnection.setHostnameVerifier(new IgnoreHostnameVerifier());
        }
        httpsUrlConnection.setRequestProperty("Content-Type", this.contentType);
        httpsUrlConnection.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        httpsUrlConnection.setDoOutput(true);
        httpsUrlConnection.setDoInput(true);
        try {
            httpsUrlConnection.setRequestMethod(this.method);
        }
        catch (ProtocolException e) {
            throw new IllegalArgumentException(String.format("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u7c7b\u578b[%s]", this.method), e);
        }
        httpsUrlConnection.setUseCaches(false);
        httpsUrlConnection.setConnectTimeout(this.connectTimeout);
        httpsUrlConnection.setReadTimeout(this.readTimeout);
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            outputStream = httpsUrlConnection.getOutputStream();
            outputStream.write(request.getBytes(StandardCharsets.UTF_8.name()));
            outputStream.flush();
            outputStream.close();
            inputStream = httpsUrlConnection.getInputStream();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int num = inputStream.read(buffer);
            while (num != -1) {
                baos.write(buffer, 0, num);
                num = inputStream.read(buffer);
            }
            baos.flush();
            response = baos.toString(StandardCharsets.UTF_8.name()).trim();
            inputStream.close();
        }
        catch (IOException e) {
            log.error("\u53d1\u9001\u8bf7\u6c42\u51fa\u9519", (Throwable)e);
            throw new RuntimeException("\u53d1\u9001\u8bf7\u6c42\u51fa\u9519", e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (httpsUrlConnection != null) {
                httpsUrlConnection.disconnect();
            }
        }
        return response;
    }

    public boolean isUseDefaultSSLSocketFactory() {
        return this.useDefaultSSLSocketFactory;
    }

    public void setUseDefaultSSLSocketFactory(boolean useDefaultSSLSocketFactory) {
        this.useDefaultSSLSocketFactory = useDefaultSSLSocketFactory;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    @Override
    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public void setIgnoreHostname(boolean ignoreHostname) {
        this.ignoreHostname = ignoreHostname;
    }
}

