/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.common.utils;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Enumeration;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PayUtils {
    private static final Logger log = LoggerFactory.getLogger(PayUtils.class);
    public static final String DIGEST_ALGORITHM_MD5 = "MD5";
    public static final String DIGEST_ALGORITHM_SHA1 = "SHA-1";
    public static final String DATA_SECURITY_RSA = "RSA";
    public static final String SIGNATURE_ALGORITHM_MD5_WITH_RSA = "MD5withRSA";
    public static final String SIGNATURE_ALGORITHM_SHA1_WITH_RSA = "SHA1withRSA";
    public static final String SIGNATURE_ALGORITHM_SHA256_WITH_RSA = "SHA256withRSA";
    public static final String KEY_STORE_TYPE_PKCS12 = "PKCS12";
    public static final String KEY_TYPE_X509 = "X.509";
    public static final String BEGIN_CERTIFICATE = "-----BEGIN CERTIFICATE-----\n";
    public static final String END_CERTIFICATE = "\n-----END CERTIFICATE-----\n";
    static byte[] KEY_DATA = new byte[]{-28, -72, -83, -23, -121, -111, -26, -108, -81, -28, -69, -104, -26, -100, -119, -23, -103, -112, -27, -123, -84, -27, -113, -72};
    static byte[] IV_DATA = new byte[]{67, 112, 99, 110, 49, 64, 51, 52};
    public static String[] SIGNATURE_ALGORITHMS_IN_USE = new String[]{"SHA1withRSA", "SHA256withRSA"};

    private PayUtils() {
        throw new UnsupportedOperationException("\u8be5\u5de5\u5177\u7c7b\u4e0d\u652f\u6301\u5b9e\u4f8b\u5316");
    }

    public static PrivateKey getPrivateKeyFromPFX(String pfxfilename, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE_PKCS12);
        FileInputStream fis = new FileInputStream(pfxfilename);
        keyStore.load(fis, password.toCharArray());
        fis.close();
        Enumeration<String> aliases = keyStore.aliases();
        String alias = aliases.nextElement();
        return (PrivateKey)keyStore.getKey(alias, password.toCharArray());
    }

    public static PrivateKey getPrivateKeyFromPFXForRSA(String pfxFileName, String pfxPassword) throws Exception {
        FileInputStream file_inputstream = new FileInputStream(pfxFileName);
        KeyStore keyStore = KeyStore.getInstance(KEY_STORE_TYPE_PKCS12);
        keyStore.load(file_inputstream, pfxPassword.toCharArray());
        String alias = null;
        Enumeration<String> aliases = keyStore.aliases();
        if (aliases.hasMoreElements()) {
            alias = aliases.nextElement().toString();
        }
        Key key = keyStore.getKey(alias, pfxPassword.toCharArray());
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(key.getEncoded());
        KeyFactory keyFactory = KeyFactory.getInstance(DATA_SECURITY_RSA);
        return keyFactory.generatePrivate(keySpec);
    }

    public static byte[] digest(String message, String algorithm) throws Exception {
        MessageDigest md = MessageDigest.getInstance(algorithm);
        md.update(message.getBytes(StandardCharsets.UTF_8));
        return md.digest();
    }

    public static byte[] digest(String message) throws Exception {
        return PayUtils.digest(message, DIGEST_ALGORITHM_MD5);
    }

    public static X509Certificate generateCertificate(String base64string) throws CertificateException, UnsupportedEncodingException {
        if (!base64string.startsWith(BEGIN_CERTIFICATE)) {
            base64string = StringUtils.join((Object[])new String[]{BEGIN_CERTIFICATE, base64string, END_CERTIFICATE});
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(base64string.getBytes(StandardCharsets.UTF_8));
        CertificateFactory cf = CertificateFactory.getInstance(KEY_TYPE_X509);
        return (X509Certificate)cf.generateCertificate(bais);
    }

    public static X509Certificate generateCertificate(String base64string, String charset) throws CertificateException, UnsupportedEncodingException {
        if (!base64string.startsWith(BEGIN_CERTIFICATE)) {
            base64string = StringUtils.join((Object[])new String[]{BEGIN_CERTIFICATE, base64string, END_CERTIFICATE});
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(base64string.getBytes(charset));
        CertificateFactory cf = CertificateFactory.getInstance(KEY_TYPE_X509);
        return (X509Certificate)cf.generateCertificate(bais);
    }

    public static X509Certificate generateCertificate(FileInputStream fis) throws CertificateException {
        CertificateFactory cf = CertificateFactory.getInstance(KEY_TYPE_X509);
        return (X509Certificate)cf.generateCertificate(fis);
    }

    public static KeyManager[] getKeyManagers(String keyStore, String keyStoreType, String keyStorePassword) throws Exception {
        String algorithm = KeyManagerFactory.getDefaultAlgorithm();
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
        KeyStore ks = KeyStore.getInstance(keyStoreType);
        FileInputStream fis = new FileInputStream(keyStore);
        ks.load(fis, keyStorePassword.toCharArray());
        fis.close();
        kmf.init(ks, keyStorePassword.toCharArray());
        KeyManager[] kms = kmf.getKeyManagers();
        return kms;
    }

    public static TrustManager[] getTrustManagers(String trustStore, String trustStoreType, String trustStorePassword) throws Exception {
        String algorithm = TrustManagerFactory.getDefaultAlgorithm();
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(algorithm);
        KeyStore keyStore = KeyStore.getInstance(trustStoreType);
        FileInputStream fileInputStream = new FileInputStream(trustStore);
        keyStore.load(fileInputStream, trustStorePassword.toCharArray());
        fileInputStream.close();
        trustManagerFactory.init(keyStore);
        TrustManager[] tms = trustManagerFactory.getTrustManagers();
        return tms;
    }

    public static byte[] decryptRSAToByte(String encryptedDataBase64, PrivateKey privateKey) {
        Validate.notBlank((CharSequence)encryptedDataBase64, (String)"\u89e3\u5bc6\u6587\u672c\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)privateKey, (String)"\u79c1\u94a5\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        byte[] plainBinary = null;
        try {
            Cipher rsaCipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            rsaCipher.init(2, privateKey);
            byte[] encodedBytes = Base64.decode((String)encryptedDataBase64);
            plainBinary = rsaCipher.doFinal(encodedBytes);
        }
        catch (Exception e) {
            log.error("\u89e3\u5bc6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u89e3\u5bc6\u5185\u5bb9\u6216\u8005\u5bc6\u94a5\u662f\u5426\u6b63\u786e!", (Throwable)e);
            throw new RuntimeException("\u89e3\u5bc6\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u89e3\u5bc6\u5185\u5bb9\u6216\u8005\u5bc6\u94a5\u662f\u5426\u6b63\u786e!", e);
        }
        return plainBinary;
    }

    public static String convertSignatureAlgorithm(String algorithm) {
        String result = null;
        algorithm = StringUtils.trim((String)algorithm);
        for (String algorithmInUse : SIGNATURE_ALGORITHMS_IN_USE) {
            if (!algorithmInUse.equalsIgnoreCase(algorithm)) continue;
            result = algorithmInUse;
            break;
        }
        return result;
    }

    public static byte[] DES3_CBC_Decrypt(byte[] ivData, byte[] keyData, byte[] cipherText) {
        SecretKeySpec key3Des = new SecretKeySpec(keyData, "DESede");
        IvParameterSpec IvSpec = new IvParameterSpec(ivData);
        byte[] plainText = null;
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(2, (Key)key3Des, IvSpec);
            plainText = cipher.doFinal(cipherText);
        }
        catch (Exception e) {
            log.error("DecryptCipher Exception", (Throwable)e);
        }
        return plainText;
    }

    public static byte[] DES3_CBC_Encrypt(byte[] ivData, byte[] keyData, byte[] plainText) throws Exception {
        SecretKeySpec key3Des = new SecretKeySpec(keyData, "DESede");
        IvParameterSpec IvSpec = new IvParameterSpec(ivData);
        byte[] cipherText = null;
        Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
        cipher.init(1, (Key)key3Des, IvSpec);
        cipherText = cipher.doFinal(plainText);
        return cipherText;
    }

    public static String DES3_Decrypt(String cipherText) throws Exception {
        String plainText = "";
        if (!StringUtils.isEmpty((CharSequence)cipherText)) {
            SecretKeySpec key3Des = new SecretKeySpec(KEY_DATA, "DESede");
            IvParameterSpec IvSpec = new IvParameterSpec(IV_DATA);
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(2, (Key)key3Des, IvSpec);
            plainText = new String(cipher.doFinal(PayUtils.hex2bytes(cipherText)));
        }
        return plainText;
    }

    public static String DES3_Encrypt(String plainText) throws Exception {
        String cipherText = "";
        if (!StringUtils.isEmpty((CharSequence)plainText)) {
            cipherText = PayUtils.bytes2hex(PayUtils.DES3_CBC_Encrypt(IV_DATA, KEY_DATA, plainText.getBytes(StandardCharsets.UTF_8)));
        }
        return cipherText;
    }

    public static String DES3_CBC_Decrypt(String cipherText) throws Exception {
        String plainText = "";
        if (!StringUtils.isEmpty((CharSequence)cipherText)) {
            SecretKeySpec key3Des = new SecretKeySpec(KEY_DATA, "DESede");
            IvParameterSpec IvSpec = new IvParameterSpec(IV_DATA);
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            cipher.init(2, (Key)key3Des, IvSpec);
            plainText = new String(cipher.doFinal(PayUtils.hex2bytes(cipherText)));
        }
        return plainText;
    }

    public static String DES3_CBC_Encrypt(String plainText) throws Exception {
        String cipherText = "";
        if (!StringUtils.isEmpty((CharSequence)plainText)) {
            cipherText = PayUtils.bytes2hex(PayUtils.DES3_CBC_Encrypt(IV_DATA, KEY_DATA, plainText.getBytes(StandardCharsets.UTF_8)));
        }
        return cipherText;
    }

    public static String encryptByRSA(byte[] plainData, PublicKey publicKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(1, publicKey);
        byte[] output = cipher.doFinal(plainData);
        return new String(Base64.encode((byte[])output));
    }

    public static String decryptRSA(String plainData, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        byte[] output = cipher.doFinal(Base64.decode((String)plainData));
        return new String(output);
    }

    public static String getDecryptKeyByteByRSA(String signData, PrivateKey privateKey) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
        cipher.init(2, privateKey);
        byte[] output = cipher.doFinal(Base64.decode((String)signData));
        byte[] keyType = new byte[3];
        System.arraycopy(output, 0, keyType, 0, 3);
        byte[] key = new byte[output.length - 3];
        System.arraycopy(output, 3, key, 0, output.length - 3);
        String keyString = new String(keyType) + PayUtils.bytes2hex(key);
        return keyString;
    }

    public static byte[] hex2bytes(String hexString) {
        hexString = hexString.toUpperCase();
        char[] chars = hexString.toCharArray();
        byte[] bytes = new byte[chars.length / 2];
        int index = 0;
        for (int i = 0; i < chars.length; i += 2) {
            byte newByte = 0;
            newByte = (byte)(newByte | PayUtils.char2byte(chars[i]));
            newByte = (byte)(newByte << 4);
            bytes[index] = newByte = (byte)(newByte | PayUtils.char2byte(chars[i + 1]));
            ++index;
        }
        return bytes;
    }

    public static String bytes2hex(byte[] bytes) {
        String result = "";
        if (null == bytes) {
            return null;
        }
        for (int i = 0; i < bytes.length; ++i) {
            StringBuilder b = new StringBuilder(Integer.toHexString(bytes[i] & 0xFF));
            if (b.length() == 1) {
                b.insert(0, "0");
            }
            result = result + b.toString();
        }
        return result.toUpperCase();
    }

    public static String randomHexString(int len) {
        StringBuffer result = new StringBuffer();
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < len; ++i) {
            result.append(Integer.toHexString(((Random)random).nextInt(16)));
        }
        return result.toString().toUpperCase();
    }

    public static byte char2byte(char ch) {
        switch (ch) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': {
                return 10;
            }
            case 'B': {
                return 11;
            }
            case 'C': {
                return 12;
            }
            case 'D': {
                return 13;
            }
            case 'E': {
                return 14;
            }
            case 'F': {
                return 15;
            }
        }
        throw new IllegalArgumentException(String.format("\u9519\u8bef\u7684\u53c2\u6570[%c]", Character.valueOf(ch)));
    }
}

