/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.common.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class XmlUtils {
    private static final Logger log = LoggerFactory.getLogger(XmlUtils.class);

    public static Schema createSchema(File schemaFile) throws Exception {
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        return schemaFactory.newSchema(schemaFile);
    }

    public static void validateViaDOM(Document document, Schema schema) throws Exception {
        DOMSource source = new DOMSource(document);
        Validator validator = schema.newValidator();
        validator.validate(source);
    }

    public static void validateViaDOM(String xmlString, Schema schema) throws Exception {
        DOMSource source = new DOMSource(XmlUtils.createDocument(xmlString));
        Validator validator = schema.newValidator();
        validator.validate(source);
    }

    public static void validateViaSAX(String xmlString, Schema schema) throws Exception {
        SAXSource source = new SAXSource(new InputSource(new InputStreamReader(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8.name())))));
        Validator validator = schema.newValidator();
        validator.validate(source);
    }

    public static void validateViaStreamSource(String xmlString, Schema schema) throws Exception {
        StreamSource source = new StreamSource(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8)));
        Validator validator = schema.newValidator();
        validator.validate(source);
    }

    public static Document createDocument(String xmlString) throws Exception {
        DocumentBuilder documentBuilder = XmlUtils.createDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8)));
    }

    public static Document createDocument(String xmlString, String charset) throws Exception {
        DocumentBuilder documentBuilder = XmlUtils.createDocumentBuilder();
        return documentBuilder.parse(new ByteArrayInputStream(xmlString.getBytes(charset)));
    }

    public static Document createDocument(File xmlFile) throws Exception {
        DocumentBuilder documentBuilder = XmlUtils.createDocumentBuilder();
        return documentBuilder.parse(xmlFile);
    }

    public static DocumentBuilder createDocumentBuilder() throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        return documentBuilderFactory.newDocumentBuilder();
    }

    public static String getNodeText(Document document, String nodeName) throws Exception {
        return XmlUtils.getNodeText(document, nodeName, 0);
    }

    public static String getNodeText(Document document, String nodeName, int index) throws Exception {
        NodeList nodeList = document.getElementsByTagName(nodeName);
        if (nodeList == null || index >= nodeList.getLength()) {
            return null;
        }
        return nodeList.item(index).getTextContent();
    }

    public static String getNodeText(String xmlString, String nodeName) throws Exception {
        Document document = XmlUtils.createDocument(xmlString);
        return XmlUtils.getNodeText(document, nodeName);
    }

    public static String getChildNodeText(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || child.getNodeName() != childName) continue;
            return child.getTextContent();
        }
        return null;
    }

    public static List<String> getNodeList(Document document, String nodeName) throws Exception {
        NodeList nodeList = document.getElementsByTagName(nodeName);
        ArrayList<String> textList = new ArrayList<String>();
        if (nodeList == null) {
            return null;
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            textList.add(nodeList.item(i).getTextContent());
        }
        return textList;
    }

    public static String getNodeAttributeValue(Document document, String nodeName, String attributeName) {
        NodeList nodeList = document.getElementsByTagName(nodeName);
        if (nodeList != null && nodeList.getLength() > 0) {
            Element element = (Element)nodeList.item(0);
            return element.getAttribute(attributeName);
        }
        return null;
    }

    public static String getNodeText(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(childName)) continue;
            return child.getTextContent();
        }
        return null;
    }

    public static Node getChildNode(Node node, String childName) {
        NodeList children = node.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(childName)) continue;
            return child;
        }
        return null;
    }

    public static String createPrettyFormat(Document document) {
        return XmlUtils.createPrettyFormat(document, StandardCharsets.UTF_8.toString());
    }

    public static String createPrettyFormat(Document document, String outputCharset) {
        String result;
        DOMSource source = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("encoding", outputCharset);
            StringWriter writer = new StringWriter();
            transformer.transform(source, new StreamResult(writer));
            result = ((Object)writer).toString();
        }
        catch (TransformerException e) {
            log.error("XML Doc\u5bf9\u8c61\u8f6c\u6362\u5b57\u7b26\u4e32\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("XML Doc\u5bf9\u8c61\u8f6c\u6362\u5b57\u7b26\u4e32\u9519\u8bef", e);
        }
        return result;
    }

    public static String createCompactFormat(Document document) {
        return XmlUtils.createCompactFormat(document, StandardCharsets.UTF_8.toString());
    }

    public static String createCompactFormat(Document document, String outputCharset) {
        String result;
        DOMSource source = new DOMSource(document);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("encoding", outputCharset);
            StringWriter writer = new StringWriter();
            transformer.transform(source, new StreamResult(writer));
            result = ((Object)writer).toString();
        }
        catch (TransformerException e) {
            log.error("XML Doc\u5bf9\u8c61\u8f6c\u6362\u5b57\u7b26\u4e32\u9519\u8bef", (Throwable)e);
            throw new RuntimeException("XML Doc\u5bf9\u8c61\u8f6c\u6362\u5b57\u7b26\u4e32\u9519\u8bef", e);
        }
        return result;
    }

    private XmlUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

