/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.PayUtils;
import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import java.nio.charset.StandardCharsets;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;

public abstract class TxBaseResponse {
    protected String responseMessage;
    protected String responseSignature;
    protected String responsePlainText;
    protected String code;
    protected String message;

    public TxBaseResponse(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
        this.responseMessage = responseMessage;
        this.responseSignature = responseSignature;
        byte[] data = Base64.decode((String)responseMessage);
        this.responsePlainText = new String(data, StandardCharsets.UTF_8);
        byte[] signature = PayUtils.hex2bytes(responseSignature);
        if (!cpcnConfig.getVerifier().verify(data, signature)) {
            throw new Exception("\u9a8c\u8bc1\u7b7e\u540d\u5931\u8d25");
        }
        Document document = XmlUtils.createDocument(this.responsePlainText);
        this.code = XmlUtils.getNodeText(document, "Code");
        this.message = XmlUtils.getNodeText(document, "Message");
        this.process(document);
    }

    protected abstract void process(Document var1) throws Exception;

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public String getResponseSignature() {
        return this.responseSignature;
    }

    public String getResponsePlainText() {
        return this.responsePlainText;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String toString() {
        return "TxBaseResponse(responseMessage=" + this.getResponseMessage() + ", responseSignature=" + this.getResponseSignature() + ", responsePlainText=" + this.getResponsePlainText() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ")";
    }
}

