/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.foundationaccount;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import com.google.common.collect.Lists;
import java.util.Collection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Tx4693Response
extends TxBaseResponse {
    private String userID;
    private Collection<BankAccount> bankAccounts;

    public Tx4693Response(String responseMessage, String responseSignature, CpcnConfig cpcnConfig) throws Exception {
        super(responseMessage, responseSignature, cpcnConfig);
    }

    @Override
    protected void process(Document document) throws Exception {
        if ("2000".equals(this.code)) {
            this.userID = XmlUtils.getNodeText(document, "UserID");
            NodeList nodeList = document.getElementsByTagName("BankAccounts");
            int len = nodeList.getLength();
            this.bankAccounts = Lists.newArrayListWithCapacity((int)len);
            for (int i = 0; i < len; ++i) {
                Node node = nodeList.item(i);
                String bindingTxSN = XmlUtils.getChildNodeText(node, "BindingTxSN");
                String bankID = XmlUtils.getChildNodeText(node, "BankID");
                String bankAccountType = XmlUtils.getChildNodeText(node, "BankAccountType");
                String bankAccountName = XmlUtils.getChildNodeText(node, "BankAccountName");
                String bankAccountNumber = XmlUtils.getChildNodeText(node, "BankAccountNumber");
                String branchName = XmlUtils.getChildNodeText(node, "BranchName");
                String bankPhoneNumber = XmlUtils.getChildNodeText(node, "BankPhoneNumber");
                String cardBusinessType = XmlUtils.getChildNodeText(node, "CardBusinessType");
                BankAccount bankAccounts = new BankAccount();
                bankAccounts.setBindingTxSN(bindingTxSN);
                bankAccounts.setBankID(bankID);
                bankAccounts.setBankAccountType(bankAccountType);
                bankAccounts.setBankAccountName(bankAccountName);
                bankAccounts.setBankAccountNumber(bankAccountNumber);
                bankAccounts.setBranchName(branchName);
                bankAccounts.setBankPhoneNumber(bankPhoneNumber);
                bankAccounts.setCardBusinessType(cardBusinessType);
                this.bankAccounts.add(bankAccounts);
            }
        }
    }

    public String getUserID() {
        return this.userID;
    }

    public Collection<BankAccount> getBankAccounts() {
        return this.bankAccounts;
    }

    public class BankAccount {
        private String bindingTxSN;
        private String bankID;
        private String bankAccountType;
        private String bankAccountName;
        private String bankAccountNumber;
        private String branchName;
        private String bankPhoneNumber;
        private String cardBusinessType;
        private String transferChargeFlag;
        private String payeeUserID;
        private String payeeUserName;

        public String getBindingTxSN() {
            return this.bindingTxSN;
        }

        public String getBankID() {
            return this.bankID;
        }

        public String getBankAccountType() {
            return this.bankAccountType;
        }

        public String getBankAccountName() {
            return this.bankAccountName;
        }

        public String getBankAccountNumber() {
            return this.bankAccountNumber;
        }

        public String getBranchName() {
            return this.branchName;
        }

        public String getBankPhoneNumber() {
            return this.bankPhoneNumber;
        }

        public String getCardBusinessType() {
            return this.cardBusinessType;
        }

        public String getTransferChargeFlag() {
            return this.transferChargeFlag;
        }

        public String getPayeeUserID() {
            return this.payeeUserID;
        }

        public String getPayeeUserName() {
            return this.payeeUserName;
        }

        public void setBindingTxSN(String bindingTxSN) {
            this.bindingTxSN = bindingTxSN;
        }

        public void setBankID(String bankID) {
            this.bankID = bankID;
        }

        public void setBankAccountType(String bankAccountType) {
            this.bankAccountType = bankAccountType;
        }

        public void setBankAccountName(String bankAccountName) {
            this.bankAccountName = bankAccountName;
        }

        public void setBankAccountNumber(String bankAccountNumber) {
            this.bankAccountNumber = bankAccountNumber;
        }

        public void setBranchName(String branchName) {
            this.branchName = branchName;
        }

        public void setBankPhoneNumber(String bankPhoneNumber) {
            this.bankPhoneNumber = bankPhoneNumber;
        }

        public void setCardBusinessType(String cardBusinessType) {
            this.cardBusinessType = cardBusinessType;
        }

        public void setTransferChargeFlag(String transferChargeFlag) {
            this.transferChargeFlag = transferChargeFlag;
        }

        public void setPayeeUserID(String payeeUserID) {
            this.payeeUserID = payeeUserID;
        }

        public void setPayeeUserName(String payeeUserName) {
            this.payeeUserName = payeeUserName;
        }
    }
}

