/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.strategy.transfer.convertor;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnBillTransactionStatus;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Response;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.SplitItem;
import com.biz.crm.common.pay.support.cpcn.model.Tx5011RedirectPayModel;
import com.biz.crm.common.pay.support.cpcn.util.IPUtils;
import com.biz.crm.common.pay.support.sdk.dto.transfer.AppletPayDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.Redirect7Wechat7Applet;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.TransferCarrier;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.convertor.TransferConvertor;
import com.biz.crm.common.pay.support.sdk.vo.transfer.QRAuthCodeVo;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class Redirect7Wechat7AppletConvertor
implements TransferConvertor<Tx5011Request, Tx5011Response> {
    @Autowired(required=false)
    private CpcnConfig cpcnConfig;

    public Boolean isConvertible(TransferCarrier carrier) {
        return carrier instanceof Redirect7Wechat7Applet;
    }

    public Tx5011Request convert(TransferCarrier carrier) {
        Validate.isTrue((boolean)this.isConvertible(carrier), (String)StringUtils.join((Object[])new String[]{"\u8df3\u8f6c\u652f\u4ed8", "\u8f6c\u6362\u5668", "\u4e0d\u53ef\u8f6c\u6362"}), (Object[])new Object[0]);
        Redirect7Wechat7Applet carrierImpl = (Redirect7Wechat7Applet)carrier;
        AppletPayDto transferData = carrierImpl.getTransferData();
        Tx5011RedirectPayModel model = this.getRedirectPayModel(transferData);
        Tx5011Request tx5011Request = this.getTx5011Request(model);
        return tx5011Request;
    }

    private Tx5011RedirectPayModel getRedirectPayModel(AppletPayDto dto) {
        Tx5011RedirectPayModel model = new Tx5011RedirectPayModel();
        model.setPaymentWay("80");
        model.setPayType("31");
        model.setPayWay("51");
        model.setPlatformName(this.cpcnConfig.getPlatformName());
        model.setClientIP(IPUtils.getIp());
        model.setSubAppID(dto.getSubAppID());
        model.setSubOpenID(dto.getSubOpenID());
        model.setRedirectSource(dto.getRedirectSource());
        model.setGoodsName(dto.getGoodsName());
        model.setTxSN(dto.getTxSN());
        model.setOrderNo(dto.getOrderNo());
        model.setPayerUserID(dto.getPayerUserID());
        model.setPayeeAccountNumber(dto.getPayeeAccountNumber());
        model.setPayeeUserID(dto.getPayeeUserID());
        model.setAmount(dto.getAmount());
        model.setExpirePeriod(dto.getExpirePeriod());
        model.setPageURL(this.cpcnConfig.getNoticeUrl());
        model.setHasSubsequentSplit("2");
        model.setNoticeURL(this.cpcnConfig.getNoticeUrl());
        model.setRemark(dto.getRemark());
        return model;
    }

    private Tx5011Request getTx5011Request(Tx5011RedirectPayModel model) {
        Tx5011Request tx5011Request = new Tx5011Request();
        tx5011Request.setTxSN(model.getTxSN());
        tx5011Request.setPayerUserID(model.getPayerUserID());
        tx5011Request.setPayeeUserID(model.getPayeeUserID());
        tx5011Request.setPaymentWay(model.getPaymentWay());
        tx5011Request.setAmount(model.getAmount());
        tx5011Request.setExpirePeriod(model.getExpirePeriod());
        tx5011Request.setPageURL(model.getPageURL());
        tx5011Request.setHasSubsequentSplit(model.getHasSubsequentSplit());
        tx5011Request.setOrderNo(model.getOrderNo());
        tx5011Request.setNoticeURL(model.getNoticeURL());
        tx5011Request.setRemark(model.getRemark());
        tx5011Request.setPayeeAccountNumber(model.getPayeeAccountNumber());
        tx5011Request.setGoodsName(model.getGoodsName());
        if (BooleanEnum.TRUE.getNumStr().equals(model.getHasSubsequentSplit())) {
            ArrayList<SplitItem> splitItems = new ArrayList<SplitItem>();
            tx5011Request.setSplitItemsList(splitItems);
        }
        tx5011Request.setPlatformName(model.getPlatformName());
        tx5011Request.setClientIP(model.getClientIP());
        tx5011Request.setPayWay(model.getPayWay());
        tx5011Request.setPayType(model.getPayType());
        tx5011Request.setRedirectPayBankID(model.getRedirectPayBankID());
        tx5011Request.setLimitPay(model.getLimitPay());
        tx5011Request.setSubAppID(model.getSubAppID());
        tx5011Request.setSubOpenID(model.getSubOpenID());
        tx5011Request.setInstallmentType(model.getInstallmentType());
        tx5011Request.setFeeMode(model.getFeeMode());
        tx5011Request.setBankAccountNumber(model.getBankAccountNumber());
        tx5011Request.setMaskAccNo(model.getMaskAccNo());
        tx5011Request.setInstallmentForce(model.getInstallmentForce());
        tx5011Request.setPhoneNumber(model.getPhoneNumber());
        tx5011Request.setLoginState(model.getLoginState());
        tx5011Request.setNumberOfInstallments(model.getNumberOfInstallments());
        tx5011Request.setIdentityInfo(model.getIdentityInfo());
        tx5011Request.setRedirectSource(model.getRedirectSource());
        return tx5011Request;
    }

    public ResponseModel<QRAuthCodeVo> parseResponse(Tx5011Response response) {
        String code = response.getCode();
        boolean isSuccess = "2000".equals(code);
        if (!isSuccess) {
            throw new RuntimeException(response.getMessage());
        }
        ResponseModel responseModel = new ResponseModel();
        responseModel.setSuccess(Boolean.valueOf(true));
        String status = response.getStatus();
        responseModel.setMessage(response.getResponseMessage());
        boolean haveUrl = CpcnBillTransactionStatus.PROCESSING.getCode().equals(status);
        if (haveUrl) {
            String qrAuthCode = response.getQRAuthCode();
            QRAuthCodeVo QRCodeVo2 = new QRAuthCodeVo();
            responseModel.setResponse((Object)QRCodeVo2);
            QRCodeVo2.setQRAuthCode(qrAuthCode);
        }
        return responseModel;
    }
}

