/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.pay.support.cpcn.strategy.transfer.convertor;

import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnBillTransactionStatus;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.aggregate.Tx5011Response;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.SplitItem;
import com.biz.crm.common.pay.support.cpcn.model.Tx5011ScanPayModel;
import com.biz.crm.common.pay.support.sdk.dto.transfer.PayDto;
import com.biz.crm.common.pay.support.sdk.model.ResponseModel;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.Scan7Aggregate7Forward;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.carrier.TransferCarrier;
import com.biz.crm.common.pay.support.sdk.strategy.transfer.convertor.TransferConvertor;
import com.biz.crm.common.pay.support.sdk.vo.transfer.QRCodeVo;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public class Scan7Aggregate7ForwardConvertor
implements TransferConvertor<Tx5011Request, Tx5011Response> {
    @Autowired(required=false)
    private CpcnConfig cpcnConfig;

    public Boolean isConvertible(TransferCarrier carrier) {
        return carrier instanceof Scan7Aggregate7Forward;
    }

    public Tx5011Request convert(TransferCarrier carrier) {
        Validate.isTrue((boolean)this.isConvertible(carrier), (String)StringUtils.join((Object[])new String[]{"\u6761\u7801\u652f\u4ed8", "\u8f6c\u6362\u5668", "\u4e0d\u53ef\u8f6c\u6362"}), (Object[])new Object[0]);
        Scan7Aggregate7Forward carrierImpl = (Scan7Aggregate7Forward)carrier;
        PayDto transferData = carrierImpl.getTransferData();
        Tx5011ScanPayModel model = this.getScanPayModel(transferData);
        Tx5011Request tx5011Request = this.getTx5011Request(model);
        return tx5011Request;
    }

    public ResponseModel<QRCodeVo> parseResponse(Tx5011Response response) {
        String code = response.getCode();
        boolean isSuccess = "2000".equals(code);
        if (!isSuccess) {
            throw new RuntimeException(response.getMessage());
        }
        ResponseModel responseModel = new ResponseModel();
        responseModel.setSuccess(Boolean.valueOf(true));
        String status = response.getStatus();
        responseModel.setMessage(response.getResponseMessage());
        boolean haveUrl = CpcnBillTransactionStatus.PROCESSING.getCode().equals(status);
        if (haveUrl) {
            String qrCodeURL = response.getQRCodeURL();
            String qRImageURL = response.getQRImageURL();
            QRCodeVo QRCodeVo2 = new QRCodeVo();
            responseModel.setResponse((Object)QRCodeVo2);
            QRCodeVo2.setQRCodeURL(qrCodeURL);
            QRCodeVo2.setQRImageURL(qRImageURL);
        }
        return responseModel;
    }

    private Tx5011ScanPayModel getScanPayModel(PayDto dto) {
        Tx5011ScanPayModel model = new Tx5011ScanPayModel();
        model.setPaymentWay("42");
        model.setScanPaymentType("40");
        model.setScanPaymentWay("41");
        if (!dto.getQRLimitPay().booleanValue()) {
            model.setScanPaymentLimitFlag("20");
        }
        model.setGoodsName(dto.getGoodsName());
        model.setCancelPayRedirectPageURL(dto.getCancelPayRedirectPageURL());
        model.setScanPageUrlType(dto.getQRPageUrlType());
        model.setRedirectPageURL(dto.getRedirectPageURL());
        model.setTxSN(dto.getTxSN());
        model.setOrderNo(dto.getOrderNo());
        model.setPayerUserID(dto.getPayerUserID());
        model.setPayeeAccountNumber(dto.getPayeeAccountNumber());
        model.setPayeeUserID(dto.getPayeeUserID());
        model.setAmount(dto.getAmount());
        model.setExpirePeriod(dto.getExpirePeriod());
        model.setPageURL(this.cpcnConfig.getNoticeUrl());
        model.setHasSubsequentSplit("2");
        model.setNoticeURL(this.cpcnConfig.getNoticeUrl());
        model.setRemark(dto.getRemark());
        return model;
    }

    private Tx5011Request getTx5011Request(Tx5011ScanPayModel model) {
        Tx5011Request tx5011Request = new Tx5011Request();
        tx5011Request.setTxSN(model.getTxSN());
        tx5011Request.setPayerUserID(model.getPayerUserID());
        tx5011Request.setPayeeUserID(model.getPayeeUserID());
        tx5011Request.setPaymentWay(model.getPaymentWay());
        tx5011Request.setAmount(model.getAmount());
        tx5011Request.setExpirePeriod(model.getExpirePeriod());
        tx5011Request.setPageURL(model.getPageURL());
        tx5011Request.setHasSubsequentSplit(model.getHasSubsequentSplit());
        tx5011Request.setOrderNo(model.getOrderNo());
        tx5011Request.setNoticeURL(model.getNoticeURL());
        tx5011Request.setRemark(model.getRemark());
        tx5011Request.setPayeeAccountNumber(model.getPayeeAccountNumber());
        tx5011Request.setGoodsName(model.getGoodsName());
        if (BooleanEnum.TRUE.getNumStr().equals(model.getHasSubsequentSplit())) {
            ArrayList<SplitItem> splitItems = new ArrayList<SplitItem>();
            tx5011Request.setSplitItemsList(splitItems);
        }
        tx5011Request.setScanPaymentType(model.getScanPaymentType());
        tx5011Request.setScanPaymentWay(model.getScanPaymentWay());
        tx5011Request.setPaymentScene(model.getPaymentScene());
        if ("90".equals(model.getPaymentScene())) {
            tx5011Request.setPreTxSN(model.getPreTxSN());
        }
        if ("42".equals(model.getScanPaymentWay())) {
            tx5011Request.setScanPaymentCode(model.getScanPaymentCode());
        }
        tx5011Request.setScanPaymentLimitFlag(model.getScanPaymentLimitFlag());
        tx5011Request.setInstallmentType(model.getInstallmentType());
        tx5011Request.setFeeMode(model.getFeeMode());
        tx5011Request.setNumberOfInstallments(model.getNumberOfInstallments());
        tx5011Request.setTerminalID(model.getTerminalID());
        tx5011Request.setAccountType(model.getAccountType());
        tx5011Request.setCancelPayRedirectPageURL(model.getCancelPayRedirectPageURL());
        tx5011Request.setScanPageUrlType(model.getScanPageUrlType());
        tx5011Request.setRedirectPageURL(model.getRedirectPageURL());
        tx5011Request.setIdentityInfo(model.getIdentityInfo());
        tx5011Request.setSubAppID(model.getSubAppID());
        tx5011Request.setBankID(model.getBankID());
        return tx5011Request;
    }
}

