package com.biz.crm.common.pay.support.cpcn.base.common.http;

import java.util.List;

/**
 * 支付请求基于http协议的请求接口
 *
 * @author Keller
 */
public interface HttpConnection {

  /**
   * 执行网络请求 暂时默认支持post
   *
   * @param uri  请求url地址
   * @param list 请求NameValuePair参数
   */
  String execute(String uri, List<NameValuePair> list);

  /**
   * 执行网络请求 暂时默认支持post
   * @param uri
   * @param list
   * @return
   */
  ResponseDgtEnvlp executeRequest(String uri, List<NameValuePair> list);

  /**
   * 执行网络请求 暂时默认支持post
   *
   * @param uri     请求url地址
   * @param request 请求内容request body
   */
  String execute(String uri, String request);

  /**
   * 网络请求连接超时
   *
   * @param connectTimeout
   */
  void setConnectTimeout(int connectTimeout);

  /**
   * 网络请求读取数据超时
   *
   * @param readTimeout
   */
  void setReadTimeout(int readTimeout);

  /**
   * 请求头媒体类型
   */
  void setContentType(String contentType);
}
