package com.biz.crm.common.pay.support.cpcn.base.common.http;

import com.biz.crm.common.pay.support.cpcn.base.common.utils.PayUtils;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

/**
 * ssl请求上下文
 *
 * 需要初始化调用该类方法初始化sslContext上下文信息
 *
 * @author Keller
 */
public class SecurityContext {
  /**
   * ssl内容，包括ssl版本协议等内容可以通过该类创建sslsocketfactory
   */
  public static SSLContext sslContext;
  /**
   * sslSocket工厂方法
   */
  public static SSLSocketFactory sslSocketFactory;

  /**
   * SSLSocketFactory 初始化方法
   *
   * 通过协议、证书进行初始化
   *
   * @param protocol
   * @param keyStore
   * @param keyStoreType
   * @param keyStorePassword
   * @param trustKeyStore
   * @param trustKeyStoreType
   * @param trustKeyStorePassword
   * @throws Exception
   */
  public static void initSSLSocketFactory(String protocol, String keyStore, String keyStoreType, String keyStorePassword, String trustKeyStore, String trustKeyStoreType, String trustKeyStorePassword) throws Exception {
    KeyManager[] kms = PayUtils.getKeyManagers(keyStore, keyStoreType, keyStorePassword);
    TrustManager[] tms = PayUtils.getTrustManagers(trustKeyStore, trustKeyStoreType, trustKeyStorePassword);
    sslContext = SSLContext.getInstance(protocol);
    sslContext.init(kms, tms, null);
    sslSocketFactory = sslContext.getSocketFactory();
  }

  /**
   * SSLSocketFactory 初始化方法
   *
   * 通过java支持的JKS证书进行初始化
   *
   * @param trustKeyStore
   * @param trustKeyStorePassword
   * @throws Exception
   */
  public static void initSSLSocketFactory(String trustKeyStore, String trustKeyStorePassword) throws Exception {
    TrustManager[] tms = PayUtils.getTrustManagers(trustKeyStore, "JKS", trustKeyStorePassword);
    sslContext = SSLContext.getInstance("TLS");
    sslContext.init(null, tms, null);
    sslSocketFactory = sslContext.getSocketFactory();
  }

  /**
   *
   * SSLSocketFactory 初始化方法
   *
   * 通过请求的协议进行初始化
   *
   * @param protocol
   * @throws Exception
   */
  public static void initSSLSocketFactory(String protocol) throws Exception {
    sslContext = SSLContext.getInstance(protocol);
    sslContext.init(null, null, null);
    sslSocketFactory = sslContext.getSocketFactory();
  }

  /**
   * 设置检查hostname过滤
   *
   * @param ignoreHostname
   * @throws Exception
   */
  public static void setIgnoreHostname(boolean ignoreHostname) {
    if (ignoreHostname) {
      HttpsURLConnection.setDefaultHostnameVerifier(new IgnoreHostnameVerifier());
    }
  }
}
