package com.biz.crm.common.pay.support.cpcn.base.cpcn.controller;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.NoticeService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.vo.NoticeInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

/**
 * 回调接口
 *
 * @author Keller
 */
@Slf4j
@RestController("CpcnNoticController")
@RequestMapping(path = "/v1/pay/notice")
@Api(tags = "中金额支付回调")
public class NoticeController {
  /**
   * 固定的返回值（中金的强烈要求）
   */
  public static final String RETURN_MESSAGE = "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz48UmVzcG9uc2UgdmVyc2lvbj0iMi4wIj48SGVhZD48Q29kZT4yMDAwPC9Db2RlPjxNZXNzYWdlPk9LLjwvTWVzc2FnZT48L0hlYWQ+PC9SZXNwb25zZT4=";

  @Autowired
  private NoticeService noticeService;

  /**
   * 统一处理中金回调
   *
   * @param request
   * @return
   */
  @ApiOperation(value = "回调请求")
  @RequestMapping(value = "", method = RequestMethod.POST)
  public String notice(HttpServletRequest request) {
    try {
      NoticeInfo data = new NoticeInfo();
      data.setMessage(request.getParameter("message"));
      data.setSignature(request.getParameter("signature"));
      noticeService.handlerNotice(data);
    } catch (Exception e) {
      log.error("处理中金回调出现错误", e);
      return null;
    }
    return RETURN_MESSAGE;
  }
}
