package com.biz.crm.common.pay.support.cpcn.base.cpcn.notice;

import cfca.sadk.util.Base64;
import com.biz.crm.common.pay.support.cpcn.base.common.utils.XmlUtils;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.config.CpcnConfig;
import lombok.Getter;

import lombok.ToString;
import org.w3c.dom.Document;

import java.nio.charset.StandardCharsets;

/**
 * 中金接口请求返回报文
 *
 * @author Keller
 */
@Getter
@ToString
public class NoticeRequest {
  /**
   * 交易明文报文
   */
  private String plainText;
  /**
   * 交易xml格式报文
   */
  private Document document;
  /**
   * 交易接口编码
   */
  private String txCode;
  /**
   * 机构配置信息
   */
  private CpcnConfig cpcnConfig;
  /**
   * 中金原文
   */
  private String message;

  public NoticeRequest(String message, String signature,CpcnConfig cpcnConfig) throws Exception {
    this.cpcnConfig = cpcnConfig;
    this.message = message;
    this.plainText = new String(Base64.decode(message), StandardCharsets.UTF_8);
//    if (!cpcnConfig.getVerifier().verify(message, signature) && !cpcnConfig.getVerifier().verify(this.plainText, signature)) {
//      throw new Exception("验证签名失败!");
//    }
    this.document = XmlUtils.createDocument(this.plainText);
    this.txCode = XmlUtils.getNodeText(this.document, "TxCode");
  }
}
