package com.biz.crm.common.pay.support.cpcn.base.cpcn.service.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.AbstractTxStrategy;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.tx.TxManager;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.TxService;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.tx.TxBaseResponse;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * 中金接口调用实现类
 * <p>
 * 采用策略模式统一封装，传递接口编号以及请求报文封装request对象即可
 * 传递对象属性信息可以查看对象属性注释或者中金接口文档
 * 接口编号与中金文档中的接口编号一一对应
 *
 * @author Keller
 */
@Slf4j
@Service
public class TxServiceImpl implements TxService {
  @Autowired
  private TxManager txManager;

  @Override
  public TxBaseResponse handlerTx(String code, TxBaseRequest request) {
    request.setTxCode(code);
    AbstractTxStrategy strategy = txManager.getHandler(code);
    return strategy.handler(request);
  }
}
