package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * 未找到对应的响应策略处理器默认输入信息
 *
 * @author Keller
 */
@Slf4j
@Component
public class NilNoticeStrategy implements NoticeStrategy {

  @Override
  public String getCode() {
    return "";
  }

  @Override
  public Object exchange(NoticeRequest request) throws Exception {
    return request;
  }

  @Override
  public void handler(NoticeRequest request) {
    log.error(String.format("数据未找到处理器%s", JSONObject.toJSONString(request)));
  }
}
