package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.internal;

import com.biz.crm.common.pay.support.cpcn.base.cpcn.common.enums.CpcnNoticeType;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.Notice4658Request;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.notice.NoticeRequest;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.service.notifier.Notice4658Listener;
import com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.notice.NoticeStrategy;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 4658-充值/提现/代付结果通知
 * <pre>
 *   支付平台收到机构系统发送的4641-充值、4643-提现、4645-单笔代付接口请求后，会请求银行进行处理，
 *   若4641-充值、4645-单笔代付和4643-提现接口同步返回处理中状态，后续支付平台获取到交易终态时会更新交易状态，
 *   并向机构系统发送该笔交易结果通知(优先向 4641 或 4643 接口上送的后台通知地址发送，
 *   4641 或 4643接口没有上送则向机构系统在上线申请时提供的后台通知地址发送，
 *   4645接口会向机构系统在上线申请时提供的后台通知地址发送通知)。
 *   机构系统收到该通知后需要给支付平台返回特定的响应，
 *   如果支付平台在5秒内未收到机构系统返回的通知响应或接收到的响应内容与规定内容不符，
 *   支付平台会认为机构系统未成功收到该通知，这时支付平台会向机构系统补发通知，
 *   最多补发 7 次，共发 8 次，各次发送时间间隔为: 0s/30s/30s/3m/10m/20m/30m/1h。
 * </pre>
 *
 * @author Keller
 */
@Slf4j
@Component
public class Notice4658Strategy implements NoticeStrategy<Notice4658Request> {
  @Autowired(required = false)
  private List<Notice4658Listener> notice4658Listeners;
  @Override
  public String getCode() {
    return CpcnNoticeType.NOTICE_4658.getCode();
  }

  @Override
  public Notice4658Request exchange(NoticeRequest request) throws Exception {
    return new Notice4658Request(request.getDocument());
  }

  @Override
  public void handler(NoticeRequest request) {
    try {
      Notice4658Request notice4658Request = exchange(request);
      // 事件通知
      if (!CollectionUtils.isEmpty(notice4658Listeners)) {
        for (Notice4658Listener listener : notice4658Listeners) {
          listener.onNotice(notice4658Request);
        }
      }
    } catch (Exception e) {
      log.error("充值/提现/代付结果通知出现错误", e);
      throw new RuntimeException(e.getLocalizedMessage());
    }
  }
}
