package com.biz.crm.common.pay.support.cpcn.base.cpcn.strategy.remote;

import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

/**
 * 通知远程应用管理器
 *
 * @author Keller
 */
@Component
@AllArgsConstructor
public class RemoteManager {
  /**
   * 回调策略容器
   */
  private List<RemoteStrategy> STRATEGYS;

  /**
   * 根据接口编号获取对应的处理策略
   *
   * @param code
   * @return
   */
  public List<RemoteStrategy> getHandler(String code) {
    List<RemoteStrategy> remoteStrategies = STRATEGYS.stream().filter(item -> Objects.equals(item.getCode(), code)).collect(Collectors.toList());
    return remoteStrategies;
  }

}
